/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax;

import com.scriptbasic.exceptions.CommandFactoryException;
import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BuildableProgram;
import com.scriptbasic.interfaces.CommandFactory;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.SyntaxAnalyzer;
import com.scriptbasic.utility.FactoryUtility;

public final class BasicSyntaxAnalyzer
implements SyntaxAnalyzer {
    private Factory factory;
    private LexicalElement lexicalElement;

    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    public LexicalElement getLexicalElement() {
        return this.lexicalElement;
    }

    public void setLexicalElement(LexicalElement lexicalElement) {
        this.lexicalElement = lexicalElement;
    }

    private static boolean lineToIgnore(String lexString) {
        return lexString.equals("\n") || lexString.equals("'") || lexString.equalsIgnoreCase("REM");
    }

    @Override
    public BuildableProgram analyze() throws AnalysisException {
        try {
            BuildableProgram buildableProgram = FactoryUtility.getProgram(this.getFactory());
            buildableProgram.reset();
            LexicalAnalyzer lexicalAnalyzer = FactoryUtility.getLexicalAnalyzer(this.getFactory());
            CommandFactory commandFactory = FactoryUtility.getCommandFactory(this.getFactory());
            this.lexicalElement = lexicalAnalyzer.peek();
            while (this.lexicalElement != null) {
                if (this.lexicalElement.isSymbol().booleanValue()) {
                    lexicalAnalyzer.get();
                    String lexString = this.lexicalElement.getLexeme();
                    if (BasicSyntaxAnalyzer.lineToIgnore(lexString)) {
                        LexicalElement le;
                        while (!lexString.equals("\n") && (le = lexicalAnalyzer.get()) != null) {
                            lexString = le.getLexeme();
                        }
                    } else {
                        buildableProgram.addCommand(commandFactory.create(this.lexicalElement.getLexeme()));
                    }
                } else {
                    buildableProgram.addCommand(commandFactory.create(null));
                }
                this.lexicalElement = lexicalAnalyzer.peek();
            }
            buildableProgram.postprocess();
            return buildableProgram;
        }
        catch (CommandFactoryException e) {
            throw new GenericSyntaxException(e.getMessage(), this.lexicalElement, e);
        }
    }
}

