/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.hooks;

import com.scriptbasic.executors.commands.CommandMethod;
import com.scriptbasic.executors.commands.CommandUse;
import com.scriptbasic.hooks.SimpleHook;
import com.scriptbasic.interfaces.Command;
import com.scriptbasic.interfaces.Configuration;

public class RunLimitHook
extends SimpleHook {
    private int stepLimit;
    private boolean stepIsLimited;
    private int currentSteps;
    private long timeLimitMillis;
    private boolean timeIsLimited;
    private long scriptStartTime;
    private boolean allowMethodRegistering = true;
    private static final String configPrefix = "RunLimitHook.";

    private static String X(String s) {
        return configPrefix + s;
    }

    @Override
    public void initEx() {
        String timeLimitMillisString;
        this.currentSteps = 0;
        this.scriptStartTime = System.currentTimeMillis();
        Configuration config = this.getInterpreter().getConfiguration();
        String stepLimitString = config.getConfigValue(RunLimitHook.X("stepLimit"));
        boolean bl = this.stepIsLimited = stepLimitString != null;
        if (this.stepIsLimited) {
            this.stepLimit = Integer.valueOf(stepLimitString);
        }
        boolean bl2 = this.timeIsLimited = (timeLimitMillisString = config.getConfigValue(RunLimitHook.X("timeLimitMillis"))) != null;
        if (this.timeIsLimited) {
            this.timeLimitMillis = Long.valueOf(timeLimitMillisString);
            this.scriptStartTime = System.currentTimeMillis();
        }
        this.allowMethodRegistering = Boolean.valueOf(config.getConfigValue(RunLimitHook.X("allowJavaMethods"), "true"));
    }

    @Override
    public void beforeExecuteEx(Command command) {
        if (this.stepIsLimited) {
            ++this.currentSteps;
            if (this.currentSteps > this.stepLimit) {
                throw new RuntimeException("The code exceeded the maximum number of steps");
            }
            if (!this.allowMethodRegistering && (command instanceof CommandMethod || command instanceof CommandUse)) {
                throw new RuntimeException("Registering Java methods is forbidden in the configuration");
            }
        }
        if (this.timeIsLimited && System.currentTimeMillis() - this.scriptStartTime > this.timeLimitMillis) {
            throw new RuntimeException("The code exceeded the maximum allowed time");
        }
    }
}

