/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.exceptions.LexicalException;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.utility.FactoryUtility;
import com.scriptbasic.utility.UtilityUtility;

public final class LexUtility {
    private LexUtility() {
        UtilityUtility.throwExceptionToEnsureNobodyCallsIt();
    }

    public static LexicalElement peek(LexicalAnalyzer lexicalAnalyzer) throws AnalysisException {
        try {
            return lexicalAnalyzer.peek();
        }
        catch (LexicalException e) {
            throw new GenericSyntaxException(e);
        }
    }

    public static LexicalElement get(LexicalAnalyzer lexicalAnalyzer) throws AnalysisException {
        try {
            return lexicalAnalyzer.get();
        }
        catch (LexicalException e) {
            throw new GenericSyntaxException(e);
        }
    }

    public static boolean isLexeme(Factory factory, String lexeme) throws AnalysisException {
        LexicalAnalyzer lexicalAnalyzer = FactoryUtility.getLexicalAnalyzer(factory);
        LexicalElement lexicalElement = lexicalAnalyzer.peek();
        if (lexicalElement != null && lexicalElement.isSymbol().booleanValue() && lexeme.equalsIgnoreCase(lexicalElement.getLexeme())) {
            lexicalAnalyzer.get();
            return true;
        }
        return false;
    }

    public static void checkLexeme(Factory factory, String lexeme, String exceptionText) throws AnalysisException {
        if (!LexUtility.isLexeme(factory, lexeme)) {
            throw new GenericSyntaxException(exceptionText);
        }
    }
}

