/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.readers;

import com.scriptbasic.interfaces.SourceProvider;
import com.scriptbasic.interfaces.SourceReader;
import com.scriptbasic.utility.CharUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.Deque;
import java.util.LinkedList;

public class GenericSourceReader
implements SourceReader {
    private final Reader sourceReader;
    private final SourceProvider sourceProvider;
    private final String sourceFileName;
    private int lineNumber = 0;
    private int position = 0;
    private Integer lastChar = null;
    private Deque<Integer> charsAhead = new LinkedList<Integer>();

    public GenericSourceReader(Reader sourceReader, SourceProvider sourceProvider, String sourceFileName) {
        this.sourceFileName = sourceFileName;
        this.sourceReader = sourceReader;
        this.sourceProvider = sourceProvider;
    }

    @Override
    public String getFileName() {
        return this.sourceFileName;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void pushBack(Integer ch) {
        if (ch != null) {
            this.charsAhead.addFirst(ch);
            --this.position;
        }
    }

    @Override
    public Integer get() {
        Integer nextChar;
        if (!this.charsAhead.isEmpty()) {
            ++this.position;
            return this.charsAhead.removeFirst();
        }
        try {
            while (this.isIgnored(nextChar = Integer.valueOf(this.sourceReader.read()))) {
            }
            if (nextChar == -1) {
                nextChar = null;
            }
        }
        catch (IOException e) {
            return null;
        }
        if (this.lastChar != null && CharUtils.isNewLine(this.lastChar)) {
            this.position = 0;
            ++this.lineNumber;
        }
        ++this.position;
        this.lastChar = nextChar;
        return this.lastChar;
    }

    private boolean isIgnored(Integer nextChar) {
        return nextChar == 13;
    }

    @Override
    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }
}

