/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.lexer.elements;

import com.scriptbasic.exceptions.LexicalException;
import com.scriptbasic.interfaces.KeywordRecognizer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.lexer.BasicLexialElementFactory;
import com.scriptbasic.lexer.BasicLexicalElement;
import com.scriptbasic.lexer.elements.AbstractElementAnalyzer;
import com.scriptbasic.readers.SourceReader;

public class Identifier
extends AbstractElementAnalyzer {
    private static final int IDENTIFIER_STRINGBUILDER_INITIAL_CAPACITY = 32;
    private KeywordRecognizer keywordRecognizer = null;

    public Identifier(SourceReader reader) {
        super(reader);
    }

    public void setKeywordRecognizer(KeywordRecognizer keywordRecognizer) {
        this.keywordRecognizer = keywordRecognizer;
    }

    @Override
    public LexicalElement read() throws LexicalException {
        Integer ch = this.getReader().get();
        if (Character.isUnicodeIdentifierStart(ch)) {
            StringBuilder identifier = new StringBuilder(32);
            while (ch != null && Character.isUnicodeIdentifierPart(ch)) {
                identifier.appendCodePoint(ch);
                ch = this.getReader().get();
            }
            this.getReader().unget(ch);
            String s = identifier.toString();
            BasicLexicalElement le = BasicLexialElementFactory.create(this.getReader(), this.keywordRecognizer.isRecognized(s) ? 5 : 4);
            le.setLexeme(s);
            le.setStringValue(s);
            return le;
        }
        this.getReader().unget(ch);
        return null;
    }
}

