/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.lexer.elements;

import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.ScriptBasicKeyWords;
import com.scriptbasic.lexer.BasicLexialElementFactory;
import com.scriptbasic.lexer.BasicLexicalElement;
import com.scriptbasic.lexer.elements.AbstractElementAnalyzer;
import com.scriptbasic.readers.SourceReader;

public class MultiCharacter
extends AbstractElementAnalyzer
implements ScriptBasicKeyWords {
    public MultiCharacter(SourceReader reader) {
        super(reader);
    }

    private void readAhead(StringBuilder stringBuider, int totalCharsToReadAhead) {
        for (int charsToReadAhead = totalCharsToReadAhead; charsToReadAhead > 0; --charsToReadAhead) {
            Integer ch = this.getReader().get();
            if (ch == null || Character.isWhitespace(ch)) {
                this.getReader().unget(ch);
                break;
            }
            stringBuider.appendCodePoint(ch);
        }
    }

    private void pushBack(StringBuilder stringBuilder, int totalCharsToPushBack) {
        int pos = stringBuilder.length() - 1;
        for (int charsToPushBack = totalCharsToPushBack; charsToPushBack > 0; --charsToPushBack) {
            this.getReader().unget(Integer.valueOf(stringBuilder.charAt(pos)));
            --pos;
        }
    }

    @Override
    public LexicalElement read() {
        BasicLexicalElement le = null;
        StringBuilder sb = new StringBuilder(2);
        this.readAhead(sb, 2);
        String s = sb.toString();
        for (String operator : BASIC_OPERATORS) {
            if (!s.startsWith(operator)) continue;
            this.pushBack(sb, s.length() - operator.length());
            le = BasicLexialElementFactory.create(this.getReader(), 5);
            le.setLexeme(operator);
            le.setStringValue(null);
            le.setType(5);
            break;
        }
        if (le == null) {
            this.pushBack(sb, sb.length());
        }
        return le;
    }
}

