/*
 * Decompiled with CFR 0.152.
 */
package com.sovren.utilities;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDate;

public class SovrenJsonSerializer {
    private static final Gson _prettyGson = SovrenJsonSerializer.getBuilder().setPrettyPrinting().create();
    private static final Gson _compactGson = SovrenJsonSerializer.getBuilder().create();

    private static GsonBuilder getBuilder() {
        return new GsonBuilder().registerTypeAdapter(LocalDate.class, (Object)new JsonDeserializer<LocalDate>(){

            public LocalDate deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
                return LocalDate.parse(json.getAsJsonPrimitive().getAsString());
            }
        }).registerTypeAdapter(LocalDate.class, (Object)new JsonSerializer<LocalDate>(){

            public JsonElement serialize(LocalDate date, Type type, JsonSerializationContext context) {
                return new JsonPrimitive(date.toString());
            }
        });
    }

    public static String serialize(Object o) {
        return SovrenJsonSerializer.serialize(o, false);
    }

    public static String serialize(Object o, boolean formatted) {
        return formatted ? _prettyGson.toJson(o) : _compactGson.toJson(o);
    }

    public static <T> T deserialize(String json, Class<T> classOfT) {
        return (T)_compactGson.fromJson(json, classOfT);
    }
}

