/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.resolver;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectUtils;
import com.sqlapp.data.db.dialect.resolver.ProductNameDialectResolver;
import com.sqlapp.data.db.dialect.resolver.VersionResolver;
import com.sqlapp.data.db.dialect.sqlserver.SqlServer2000;
import com.sqlapp.data.db.dialect.sqlserver.SqlServer2005;
import com.sqlapp.data.db.dialect.sqlserver.SqlServer2008;
import com.sqlapp.data.db.dialect.sqlserver.SqlServer2012;
import com.sqlapp.data.db.dialect.sqlserver.SqlServer2014;
import com.sqlapp.data.db.dialect.sqlserver.SqlServer2016;
import com.sqlapp.data.db.dialect.sqlserver.SqlServer2016Sp1;
import com.sqlapp.data.db.dialect.sqlserver.SqlServer2017;
import com.sqlapp.data.db.dialect.sqlserver.SqlServer2019;

public class SqlServerDialectResolver
extends ProductNameDialectResolver {
    public static final SqlServerDialectResolver instance = new SqlServerDialectResolver();

    public SqlServerDialectResolver() {
        super("(Microsoft *SQL *Server.*|MS *SQL)", (VersionResolver)new SqlServerVersionResolver());
    }

    public static SqlServerDialectResolver getInstance() {
        return instance;
    }

    static class SqlServerVersionResolver
    implements VersionResolver {
        private static final long serialVersionUID = 1L;

        public Dialect getDialect(int majorVersion, int minorVersion, Integer revision) {
            if (majorVersion >= 15) {
                return DialectHolder.defaultDialect2019;
            }
            if (majorVersion >= 14) {
                return DialectHolder.defaultDialect2017;
            }
            if (majorVersion >= 13) {
                if (minorVersion > 1) {
                    return DialectHolder.defaultDialect2016Sp1;
                }
                return DialectHolder.defaultDialect2016;
            }
            if (majorVersion >= 12) {
                return DialectHolder.defaultDialect2014;
            }
            if (majorVersion >= 11) {
                return DialectHolder.defaultDialect2012;
            }
            if (majorVersion >= 10) {
                if (minorVersion >= 50) {
                    return DialectHolder.defaultDialect2008R2;
                }
                return DialectHolder.defaultDialect2008;
            }
            if (majorVersion >= 9) {
                return DialectHolder.defaultDialect2005;
            }
            if (majorVersion >= 8) {
                return DialectHolder.defaultDialect2000;
            }
            return DialectHolder.defaultDialect2000;
        }

        static class DialectHolder {
            static final Dialect defaultDialect2019 = DialectUtils.getInstance(SqlServer2019.class);
            static final Dialect defaultDialect2017 = DialectUtils.getInstance(SqlServer2017.class, () -> defaultDialect2019);
            static final Dialect defaultDialect2016Sp1 = DialectUtils.getInstance(SqlServer2016Sp1.class, () -> defaultDialect2017);
            static final Dialect defaultDialect2016 = DialectUtils.getInstance(SqlServer2016.class, () -> defaultDialect2016Sp1);
            static final Dialect defaultDialect2014 = DialectUtils.getInstance(SqlServer2014.class, () -> defaultDialect2016);
            static final Dialect defaultDialect2012 = DialectUtils.getInstance(SqlServer2012.class, () -> defaultDialect2014);
            static final Dialect defaultDialect2008;
            static final Dialect defaultDialect2008R2;
            static final Dialect defaultDialect2005;
            static final Dialect defaultDialect2000;

            DialectHolder() {
            }

            static {
                defaultDialect2008R2 = defaultDialect2008 = DialectUtils.getInstance(SqlServer2008.class, () -> defaultDialect2012);
                defaultDialect2005 = DialectUtils.getInstance(SqlServer2005.class, () -> defaultDialect2008);
                defaultDialect2000 = DialectUtils.getInstance(SqlServer2000.class, () -> defaultDialect2005);
            }
        }
    }
}

