/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.resolver;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.resolver.ProductNameDialectResolver;
import com.sqlapp.data.db.dialect.resolver.VersionResolver;
import com.sqlapp.data.db.dialect.sqlserver.DialectHolder;

public class SqlServerDialectResolver
extends ProductNameDialectResolver {
    public static final SqlServerDialectResolver instance = new SqlServerDialectResolver();

    public SqlServerDialectResolver() {
        super("(Microsoft *SQL *Server.*|MS *SQL)", (VersionResolver)new SqlServerVersionResolver());
    }

    public static SqlServerDialectResolver getInstance() {
        return instance;
    }

    static class SqlServerVersionResolver
    implements VersionResolver {
        private static final long serialVersionUID = 1L;

        public Dialect getDialect(int majorVersion, int minorVersion, Integer revision) {
            if (majorVersion >= 15) {
                return DialectHolder.defaultDialect2019;
            }
            if (majorVersion >= 14) {
                return DialectHolder.defaultDialect2017;
            }
            if (majorVersion >= 13) {
                if (minorVersion > 1) {
                    return DialectHolder.defaultDialect2016Sp1;
                }
                return DialectHolder.defaultDialect2016;
            }
            if (majorVersion >= 12) {
                return DialectHolder.defaultDialect2014;
            }
            if (majorVersion >= 11) {
                return DialectHolder.defaultDialect2012;
            }
            if (majorVersion >= 10) {
                if (minorVersion >= 50) {
                    return DialectHolder.defaultDialect2008R2;
                }
                return DialectHolder.defaultDialect2008;
            }
            if (majorVersion >= 9) {
                return DialectHolder.defaultDialect2005;
            }
            if (majorVersion >= 8) {
                return DialectHolder.defaultDialect2000;
            }
            return DialectHolder.defaultDialect2000;
        }
    }
}

