/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2008TypeColumnReader;
import com.sqlapp.data.db.metadata.TypeColumnReader;
import com.sqlapp.data.db.metadata.TypeReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Type;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2008TypeReader
extends TypeReader {
    protected SqlServer2008TypeReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Type> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        final List result = CommonUtils.list();
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Type obj = SqlServer2008TypeReader.this.createDbType(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("types2008.sql");
    }

    protected Type createDbType(ExResultSet rs) throws SQLException {
        String name = this.getString((ResultSet)rs, "type_name");
        Type obj = new Type(name);
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setCollation(this.getString((ResultSet)rs, "collation_name"));
        this.setSpecifics(rs, "assembly_name", (SpecificsProperty)obj);
        this.setSpecifics(rs, "assembly_class", (SpecificsProperty)obj);
        return obj;
    }

    protected TypeColumnReader newColumnFactory() {
        return new SqlServer2008TypeColumnReader(this.getDialect());
    }
}

