/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.db.metadata.TypeColumnReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.TypeColumn;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2008TypeColumnReader
extends TypeColumnReader {
    protected SqlServer2008TypeColumnReader(Dialect dialect) {
        super(dialect);
    }

    protected List<TypeColumn> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                TypeColumn column = SqlServer2008TypeColumnReader.this.createTypeColumn(rs);
                result.add(column);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("typeColumns2008.sql");
    }

    protected TypeColumn createTypeColumn(ExResultSet rs) throws SQLException {
        TypeColumn obj = this.createObject(this.getString((ResultSet)rs, "column_name"));
        String productDataType = this.getString((ResultSet)rs, "column_type_name");
        Long byteLength = this.getLong((ResultSet)rs, "max_length");
        Long max_length = SqlServerUtils.getMaxLength(productDataType, byteLength);
        long precision = rs.getLong("precision");
        Integer scale = this.getInteger((ResultSet)rs, "scale");
        obj.setNullable(rs.getBoolean("is_nullable"));
        obj.setIdentity(rs.getBoolean("is_identity"));
        this.getDialect().setDbType(productDataType, CommonUtils.notZero((Long[])new Long[]{max_length, precision}), scale, (DataTypeLengthProperties)obj);
        obj.setDefaultValue(CommonUtils.unwrap((String)this.getString((ResultSet)rs, "default_definition"), (char)'(', (char)')'));
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setTypeName(this.getString((ResultSet)rs, "type_name"));
        if (obj.isIdentity()) {
            obj.setIdentityStartValue(rs.getLong("ident_seed"));
            obj.setIdentityStep(rs.getLong("ident_increment"));
            obj.setIdentityLastValue(rs.getLong("ident_current"));
        }
        obj.setRemarks(this.getString((ResultSet)rs, "remarks"));
        String check_definition = CommonUtils.trim((String)CommonUtils.unwrap((String)this.getString((ResultSet)rs, "check_definition"), (char)'(', (char)')'));
        obj.setCheck(check_definition);
        this.setSpecifics((ResultSet)rs, "is_rowguidcol", (SpecificsProperty)obj);
        this.setSpecifics((ResultSet)rs, "xmlschema", (SpecificsProperty)obj);
        return obj;
    }
}

