/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.resolver;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectUtils;
import com.sqlapp.data.db.dialect.SqlServer2000;
import com.sqlapp.data.db.dialect.SqlServer2005;
import com.sqlapp.data.db.dialect.SqlServer2008;
import com.sqlapp.data.db.dialect.SqlServer2012;
import com.sqlapp.data.db.dialect.SqlServer2014;
import com.sqlapp.data.db.dialect.SqlServer2016;
import com.sqlapp.data.db.dialect.resolver.ProductNameDialectResolver;
import com.sqlapp.data.db.dialect.resolver.VersionResolver;

public class SqlServerDialectResolver
extends ProductNameDialectResolver {
    private static final long serialVersionUID = 1L;
    public static final SqlServerDialectResolver instance = new SqlServerDialectResolver();

    public SqlServerDialectResolver() {
        super("(Microsoft *SQL *Server.*|MS *SQL)", (VersionResolver)new SqlServerVersionResolver());
    }

    public static SqlServerDialectResolver getInstance() {
        return instance;
    }

    static class SqlServerVersionResolver
    implements VersionResolver {
        private static final long serialVersionUID = 1L;

        public Dialect getDialect(int majorVersion, int minorVersion, Integer revision) {
            switch (majorVersion) {
                case 8: {
                    return DialectHolder.defaultDialect2000;
                }
                case 9: {
                    return DialectHolder.defaultDialect2005;
                }
                case 10: {
                    if (minorVersion >= 50) {
                        return DialectHolder.defaultDialect2008R2;
                    }
                    return DialectHolder.defaultDialect2008;
                }
                case 11: {
                    return DialectHolder.defaultDialect2012;
                }
                case 12: {
                    return DialectHolder.defaultDialect2014;
                }
                case 13: {
                    return DialectHolder.defaultDialect2016;
                }
            }
            return DialectHolder.defaultDialect2000;
        }

        static class DialectHolder {
            static final Dialect defaultDialect2016 = DialectUtils.getInstance(SqlServer2016.class);
            static final Dialect defaultDialect2014 = DialectUtils.getInstance(SqlServer2014.class, () -> defaultDialect2016);
            static final Dialect defaultDialect2012 = DialectUtils.getInstance(SqlServer2012.class, () -> defaultDialect2014);
            static final Dialect defaultDialect2008;
            static final Dialect defaultDialect2008R2;
            static final Dialect defaultDialect2005;
            static final Dialect defaultDialect2000;

            DialectHolder() {
            }

            static {
                defaultDialect2008R2 = defaultDialect2008 = DialectUtils.getInstance(SqlServer2008.class, () -> defaultDialect2012);
                defaultDialect2005 = DialectUtils.getInstance(SqlServer2005.class, () -> defaultDialect2008);
                defaultDialect2000 = DialectUtils.getInstance(SqlServer2000.class, () -> defaultDialect2005);
            }
        }
    }
}

