/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2000ColumnReader
extends ColumnReader {
    protected SqlServer2000ColumnReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Column> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Column column = SqlServer2000ColumnReader.this.createColumn(rs);
                result.add(column);
            }
        });
        this.setColumnComments(connection, context, result);
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("columns2000.sql");
    }

    protected void setColumnComments(Connection connection, ParametersContext context, List<Column> columns) {
        String schemaName = null;
        String tableName = null;
        for (Column column : columns) {
            if (tableName == null) {
                schemaName = column.getSchemaName();
                tableName = column.getTableName();
                this.setColumnComments(connection, context, columns, schemaName, tableName);
            } else if (!CommonUtils.eq((Object)column.getSchemaName(), (Object)schemaName) || !CommonUtils.eq((Object)column.getTableName(), (Object)tableName)) {
                schemaName = column.getSchemaName();
                tableName = column.getTableName();
                this.setColumnComments(connection, context, columns, schemaName, tableName);
            }
            schemaName = column.getSchemaName();
            tableName = column.getTableName();
        }
    }

    protected void setColumnComments(Connection connection, ParametersContext context, final List<Column> columns, String schemaName, String tableName) {
        SqlNode node = this.getSqlNodeCache().getString("columnComments2000.sql");
        context.put("table_name", (Object)tableName);
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String columnName = this.getString(rs, "objname");
                String comment = this.getString(rs, "value");
                for (Column searchColumn : columns) {
                    if (!CommonUtils.eqIgnoreCase((String)columnName, (String)searchColumn.getName())) continue;
                    searchColumn.setRemarks(comment);
                }
            }
        });
    }

    protected Column createColumn(ExResultSet rs) throws SQLException {
        String productDataType = this.getString((ResultSet)rs, "type_name");
        Long byteLength = this.getLong((ResultSet)rs, "max_length");
        Long max_length = SqlServerUtils.getMaxLength(productDataType, byteLength);
        Long precision = this.getLong((ResultSet)rs, "precision");
        Integer scale = this.getInteger((ResultSet)rs, "scale");
        Column obj = new Column(this.getString((ResultSet)rs, "column_name"));
        obj.setNullable(rs.getBoolean("is_nullable"));
        obj.setIdentity(rs.getBoolean("is_identity"));
        this.getDialect().setDbType(productDataType, CommonUtils.notZero((Long[])new Long[]{max_length, precision}), scale, (DataTypeLengthProperties)obj);
        obj.setDefaultValue(CommonUtils.unwrap((String)this.getString((ResultSet)rs, "default_definition"), (char)'(', (char)')'));
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setTableName(this.getString((ResultSet)rs, "table_name"));
        if (obj.isIdentity()) {
            obj.setIdentityStartValue(rs.getLong("ident_seed"));
            obj.setIdentityStep(rs.getLong("ident_increment"));
            obj.setIdentityLastValue(rs.getLong("ident_current"));
        }
        obj.setCollation(this.getString((ResultSet)rs, "collation_name"));
        obj.setRemarks(this.getString((ResultSet)rs, "remarks"));
        return obj;
    }
}

