/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005AssemblyFileReader;
import com.sqlapp.data.db.metadata.AssemblyFileReader;
import com.sqlapp.data.db.metadata.AssemblyReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Assembly;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005AssemblyReader
extends AssemblyReader {
    protected SqlServer2005AssemblyReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Assembly> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Assembly obj = SqlServer2005AssemblyReader.this.createAssembly(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("assemblies2005.sql");
    }

    protected Assembly createAssembly(ExResultSet rs) throws SQLException {
        Assembly obj = new Assembly(this.getString((ResultSet)rs, "name"));
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setPermissionSet(this.getString((ResultSet)rs, "permission_set_desc"));
        obj.setCreatedAt(rs.getTimestamp("create_date"));
        obj.setLastAlteredAt(rs.getTimestamp("modify_date"));
        obj.setId("" + rs.getInt("assembly_id"));
        this.setSpecifics((ResultSet)rs, "clr_name", (SpecificsProperty)obj);
        return obj;
    }

    protected AssemblyFileReader newAssemblyFileReader() {
        return new SqlServer2005AssemblyFileReader(this.getDialect());
    }
}

