/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005IndexReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2008FullTextIndexReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.IndexType;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.node.SqlNode;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SqlServer2008IndexReader
extends SqlServer2005IndexReader {
    protected static final String FILTER_DEFINITION = "filter_definition";
    protected static final String TESSELLATION_SCHEMA = "tessellation_scheme";
    protected static final String BOUNDING_BOX_XMAX = "bounding_box_xmax";
    protected static final String BOUNDING_BOX_XMIN = "bounding_box_xmin";
    protected static final String BOUNDING_BOX_YMAX = "bounding_box_ymax";
    protected static final String BOUNDING_BOX_YMIN = "bounding_box_ymin";
    protected static final String LEVEL_1_GRID = "level_1_grid";
    protected static final String LEVEL_2_GRID = "level_2_grid";
    protected static final String LEVEL_3_GRID = "level_3_grid";
    protected static final String LEVEL_4_GRID = "level_4_grid";
    protected static final String CELLS_PER_OBJECT = "cells_per_object";
    public static final String STATISTICS_NORECOMPUTE = "STATISTICS_NORECOMPUTE";
    public static final String ALLOW_PAGE_LOCKS = "ALLOW_PAGE_LOCKS";
    public static final String ONLINE = "ONLINE";
    public static final String SORT_IN_TEMPDB = "SORT_IN_TEMPDB";
    public static final String MAXDOP = "MAXDOP";

    public SqlServer2008IndexReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("indexes2008.sql");
    }

    @Override
    protected IndexReader newFullTextIndexReader() {
        SqlServer2008FullTextIndexReader reader = new SqlServer2008FullTextIndexReader(this.getDialect());
        return reader;
    }

    @Override
    protected Index createIndex(ExResultSet rs) throws SQLException {
        Index index = super.createIndex(rs);
        index.setWhere(this.getString((ResultSet)rs, FILTER_DEFINITION));
        if (index.getIndexType() == IndexType.Spatial) {
            this.setSpecifics(rs, TESSELLATION_SCHEMA, (SpecificsProperty)index);
            this.setSpecifics(rs, BOUNDING_BOX_XMAX, (SpecificsProperty)index);
            this.setSpecifics(rs, BOUNDING_BOX_XMIN, (SpecificsProperty)index);
            this.setSpecifics(rs, BOUNDING_BOX_YMAX, (SpecificsProperty)index);
            this.setSpecifics(rs, BOUNDING_BOX_YMIN, (SpecificsProperty)index);
            this.setSpecifics(rs, LEVEL_1_GRID, (SpecificsProperty)index);
            this.setSpecifics(rs, LEVEL_2_GRID, (SpecificsProperty)index);
            this.setSpecifics(rs, LEVEL_3_GRID, (SpecificsProperty)index);
            this.setSpecifics(rs, LEVEL_4_GRID, (SpecificsProperty)index);
            this.setSpecifics(rs, CELLS_PER_OBJECT, (SpecificsProperty)index);
        }
        this.setSpecifics(rs, STATISTICS_NORECOMPUTE, (SpecificsProperty)index);
        this.setSpecifics(rs, ALLOW_PAGE_LOCKS, (SpecificsProperty)index);
        this.setSpecifics(rs, ONLINE, (SpecificsProperty)index);
        this.setSpecifics(rs, SORT_IN_TEMPDB, (SpecificsProperty)index);
        this.setSpecifics(rs, MAXDOP, (SpecificsProperty)index);
        return index;
    }
}

