/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackify.api.LogMsg;
import com.stackify.api.StackifyError;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.AppIdentityService;
import com.stackify.api.common.error.ErrorGovernor;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.LogBackgroundService;
import com.stackify.api.common.log.LogCollector;
import com.stackify.api.common.log.LogSender;
import com.stackify.api.common.mask.Masker;
import com.stackify.api.common.util.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import lombok.NonNull;

public class LogAppender<T>
implements Closeable {
    private static final String COM_DOT_STACKIFY = "com.stackify.";
    private final String logger;
    private final EventAdapter<T> eventAdapter;
    private LogCollector collector = null;
    private LogBackgroundService backgroundService = null;
    private final ErrorGovernor errorGovernor = new ErrorGovernor();
    private final Masker masker;

    public LogAppender(@NonNull String logger, @NonNull EventAdapter<T> eventAdapter, Masker masker) {
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (eventAdapter == null) {
            throw new NullPointerException("eventAdapter");
        }
        this.logger = logger;
        this.eventAdapter = eventAdapter;
        this.masker = masker;
    }

    public void activate(ApiConfiguration apiConfig) {
        Preconditions.checkNotNull(apiConfig);
        Preconditions.checkNotNull(apiConfig.getApiUrl());
        Preconditions.checkArgument(!apiConfig.getApiUrl().isEmpty());
        Preconditions.checkNotNull(apiConfig.getApiKey());
        Preconditions.checkArgument(!apiConfig.getApiKey().isEmpty());
        ObjectMapper objectMapper = new ObjectMapper();
        AppIdentityService appIdentityService = new AppIdentityService(apiConfig, objectMapper);
        this.collector = new LogCollector(this.logger, apiConfig.getEnvDetail(), appIdentityService);
        LogSender sender = new LogSender(apiConfig, objectMapper, this.masker);
        this.backgroundService = new LogBackgroundService(this.collector, sender);
        this.backgroundService.start();
    }

    @Override
    public void close() throws IOException {
        if (this.backgroundService != null) {
            this.backgroundService.stop();
        }
    }

    public void append(T event) {
        StackifyError e;
        if (this.backgroundService == null) {
            return;
        }
        if (!this.backgroundService.isRunning()) {
            return;
        }
        String className = this.eventAdapter.getClassName(event);
        if (className != null && className.startsWith(COM_DOT_STACKIFY)) {
            return;
        }
        Throwable exception = this.eventAdapter.getThrowable(event);
        StackifyError error = null;
        if ((exception != null || this.eventAdapter.isErrorLevel(event)) && this.errorGovernor.errorShouldBeSent(e = this.eventAdapter.getStackifyError(event, exception))) {
            error = e;
        }
        LogMsg logMsg = this.eventAdapter.getLogMsg(event, error);
        this.collector.addLogMsg(logMsg);
    }
}

