/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log.direct;

import com.stackify.api.common.ApiClients;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.ApiConfigurations;
import com.stackify.api.common.log.LogAppender;
import com.stackify.api.common.log.direct.LogEvent;
import com.stackify.api.common.log.direct.LogEventAdapter;
import com.stackify.api.common.mask.MaskerConfiguration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogManager.class);
    private static AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static ApiConfiguration CONFIG = null;
    private static LogAppender<LogEvent> LOG_APPENDER = null;

    public static LogAppender<LogEvent> getAppender() {
        if (INITIALIZED.compareAndSet(false, true)) {
            LogManager.startup();
        }
        return LOG_APPENDER;
    }

    private static synchronized void startup() {
        try {
            CONFIG = ApiConfigurations.fromProperties();
            String clientName = ApiClients.getApiClient(LogManager.class, "/stackify-api-common.properties", "stackify-api-common");
            LOG_APPENDER = new LogAppender<LogEvent>(clientName, new LogEventAdapter(CONFIG.getEnvDetail()), MaskerConfiguration.fromProperties(), CONFIG.getSkipJson());
            LOG_APPENDER.activate(CONFIG);
        }
        catch (Throwable t) {
            LOGGER.error("Exception starting Stackify Log API service", t);
        }
    }

    public static synchronized void shutdown() {
        if (LOG_APPENDER != null) {
            try {
                LOG_APPENDER.close();
            }
            catch (Throwable t) {
                LOGGER.error("Exception stopping Stackify Log API service", t);
            }
        }
    }

    private LogManager() {
    }
}

