/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackify.api.LogMsgGroup;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.log.LogTransport;
import com.stackify.api.common.log.LogTransportPreProcessor;
import com.stackify.api.common.mask.Masker;
import com.stackify.api.common.proto.LogMsgGroupConverter;
import com.stackify.api.common.proto.StackifyProto;
import com.stackify.api.common.socket.HttpSocketClient;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogTransportAgentSocket
implements LogTransport {
    private static final Logger log = LoggerFactory.getLogger(LogTransportAgentSocket.class);
    private static final String URI_PREFIX = "unix://localhost:80";
    private final ApiConfiguration apiConfig;
    private final LogTransportPreProcessor logTransportPreProcessor;
    private final HttpSocketClient httpSocketClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(LogTransportAgentSocket.class);

    public LogTransportAgentSocket(@NonNull ApiConfiguration apiConfig, Masker masker, boolean skipJson) {
        if (apiConfig == null) {
            throw new NullPointerException("apiConfig is marked non-null but is null");
        }
        this.apiConfig = apiConfig;
        this.logTransportPreProcessor = new LogTransportPreProcessor(masker, skipJson);
        this.httpSocketClient = new HttpSocketClient(apiConfig.getAgentSocketPath());
    }

    @Override
    public void send(@NonNull LogMsgGroup group) throws Exception {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        try {
            this.logTransportPreProcessor.execute(group);
            StackifyProto.LogGroup logGroup = LogMsgGroupConverter.convert(group);
            HttpPost httpPost = new HttpPost("unix://localhost:80/log");
            httpPost.setHeader("Content-Type", "application/x-protobuf");
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(logGroup.toByteArray()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("#Log #Transport #Socket Sending request to {} - Body: {}", (Object)httpPost.getURI(), (Object)new ObjectMapper().writeValueAsString((Object)group));
            }
            this.httpSocketClient.send(httpPost);
        }
        catch (Throwable e) {
            log.info("Queueing logs for retransmission due to Exception");
            log.debug(e.getMessage(), e);
            throw e;
        }
    }
}

