/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class InterviewInterviewStatus {

    /**
     * The status of the interview.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends InterviewValue> value;

    /**
     * The source value of the interview status.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends InterviewSourceValue> sourceValue;

    @JsonCreator
    public InterviewInterviewStatus(
            @JsonProperty("value") JsonNullable<? extends InterviewValue> value,
            @JsonProperty("source_value") JsonNullable<? extends InterviewSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public InterviewInterviewStatus() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The status of the interview.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<InterviewValue> value() {
        return (JsonNullable<InterviewValue>) value;
    }

    /**
     * The source value of the interview status.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<InterviewSourceValue> sourceValue() {
        return (JsonNullable<InterviewSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The status of the interview.
     */
    public InterviewInterviewStatus withValue(InterviewValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The status of the interview.
     */
    public InterviewInterviewStatus withValue(JsonNullable<? extends InterviewValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the interview status.
     */
    public InterviewInterviewStatus withSourceValue(InterviewSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the interview status.
     */
    public InterviewInterviewStatus withSourceValue(JsonNullable<? extends InterviewSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InterviewInterviewStatus other = (InterviewInterviewStatus) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(InterviewInterviewStatus.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends InterviewValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends InterviewSourceValue> sourceValue = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The status of the interview.
         */
        public Builder value(InterviewValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The status of the interview.
         */
        public Builder value(JsonNullable<? extends InterviewValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the interview status.
         */
        public Builder sourceValue(InterviewSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the interview status.
         */
        public Builder sourceValue(JsonNullable<? extends InterviewSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public InterviewInterviewStatus build() {
            return new InterviewInterviewStatus(
                value,
                sourceValue);
        }
    }
}

