/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.UpdateEmployeeApiModel;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HrisUpdateEmployeeResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends UpdateEmployeeApiModel> updateEmployeeApiModel;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisUpdateEmployeeResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends UpdateEmployeeApiModel> updateEmployeeApiModel, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(updateEmployeeApiModel, "updateEmployeeApiModel");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.updateEmployeeApiModel = updateEmployeeApiModel;
        this.headers = headers;
    }

    public HrisUpdateEmployeeResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<UpdateEmployeeApiModel> updateEmployeeApiModel() {
        return this.updateEmployeeApiModel;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HrisUpdateEmployeeResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisUpdateEmployeeResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisUpdateEmployeeResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisUpdateEmployeeResponse withUpdateEmployeeApiModel(UpdateEmployeeApiModel updateEmployeeApiModel) {
        Utils.checkNotNull(updateEmployeeApiModel, "updateEmployeeApiModel");
        this.updateEmployeeApiModel = Optional.ofNullable(updateEmployeeApiModel);
        return this;
    }

    public HrisUpdateEmployeeResponse withUpdateEmployeeApiModel(Optional<? extends UpdateEmployeeApiModel> updateEmployeeApiModel) {
        Utils.checkNotNull(updateEmployeeApiModel, "updateEmployeeApiModel");
        this.updateEmployeeApiModel = updateEmployeeApiModel;
        return this;
    }

    public HrisUpdateEmployeeResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisUpdateEmployeeResponse other = (HrisUpdateEmployeeResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.updateEmployeeApiModel, other.updateEmployeeApiModel) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.updateEmployeeApiModel, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisUpdateEmployeeResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "updateEmployeeApiModel", this.updateEmployeeApiModel, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends UpdateEmployeeApiModel> updateEmployeeApiModel = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder updateEmployeeApiModel(UpdateEmployeeApiModel updateEmployeeApiModel) {
            Utils.checkNotNull(updateEmployeeApiModel, "updateEmployeeApiModel");
            this.updateEmployeeApiModel = Optional.ofNullable(updateEmployeeApiModel);
            return this;
        }

        public Builder updateEmployeeApiModel(Optional<? extends UpdateEmployeeApiModel> updateEmployeeApiModel) {
            Utils.checkNotNull(updateEmployeeApiModel, "updateEmployeeApiModel");
            this.updateEmployeeApiModel = updateEmployeeApiModel;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisUpdateEmployeeResponse build() {
            return new HrisUpdateEmployeeResponse(this.contentType, this.statusCode, this.rawResponse, this.updateEmployeeApiModel, this.headers);
        }
    }
}

