/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.LmsCreateCollectionRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;

public class LmsUpdateCollectionRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto;

    @JsonCreator
    public LmsUpdateCollectionRequest(String xAccountId, String id, LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(lmsCreateCollectionRequestDto, "lmsCreateCollectionRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.lmsCreateCollectionRequestDto = lmsCreateCollectionRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto() {
        return this.lmsCreateCollectionRequestDto;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public LmsUpdateCollectionRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsUpdateCollectionRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public LmsUpdateCollectionRequest withLmsCreateCollectionRequestDto(LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto) {
        Utils.checkNotNull(lmsCreateCollectionRequestDto, "lmsCreateCollectionRequestDto");
        this.lmsCreateCollectionRequestDto = lmsCreateCollectionRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsUpdateCollectionRequest other = (LmsUpdateCollectionRequest)o;
        return Objects.deepEquals(this.xAccountId, other.xAccountId) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.lmsCreateCollectionRequestDto, other.lmsCreateCollectionRequestDto);
    }

    public int hashCode() {
        return Objects.hash(this.xAccountId, this.id, this.lmsCreateCollectionRequestDto);
    }

    public String toString() {
        return Utils.toString(LmsUpdateCollectionRequest.class, "xAccountId", this.xAccountId, "id", this.id, "lmsCreateCollectionRequestDto", this.lmsCreateCollectionRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder lmsCreateCollectionRequestDto(LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto) {
            Utils.checkNotNull(lmsCreateCollectionRequestDto, "lmsCreateCollectionRequestDto");
            this.lmsCreateCollectionRequestDto = lmsCreateCollectionRequestDto;
            return this;
        }

        public LmsUpdateCollectionRequest build() {
            return new LmsUpdateCollectionRequest(this.xAccountId, this.id, this.lmsCreateCollectionRequestDto);
        }
    }
}

