/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.operations;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.IamRolesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Deprecated;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class IamListRolesResponse implements Response {

    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The list of roles was retrieved.
     */
    private Optional<? extends IamRolesPaginated> iamRolesPaginated;

    private Map<String, List<String>> headers;

    private Callable<Optional<IamListRolesResponse>> next = () -> Optional.empty();

    @JsonCreator
    public IamListRolesResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends IamRolesPaginated> iamRolesPaginated,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(iamRolesPaginated, "iamRolesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.iamRolesPaginated = iamRolesPaginated;
        this.headers = headers;
    }
    
    public IamListRolesResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The list of roles was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<IamRolesPaginated> iamRolesPaginated() {
        return (Optional<IamRolesPaginated>) iamRolesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public Optional<IamListRolesResponse> next() throws Exception {
        return this.next.call();
    }
    
    // internal use only
    private IamListRolesResponse withNext(Callable<Optional<IamListRolesResponse>> next) {
        this.next = next;
        return this;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * HTTP response content type for this operation
     */
    public IamListRolesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public IamListRolesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public IamListRolesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The list of roles was retrieved.
     */
    public IamListRolesResponse withIamRolesPaginated(IamRolesPaginated iamRolesPaginated) {
        Utils.checkNotNull(iamRolesPaginated, "iamRolesPaginated");
        this.iamRolesPaginated = Optional.ofNullable(iamRolesPaginated);
        return this;
    }

    /**
     * The list of roles was retrieved.
     */
    public IamListRolesResponse withIamRolesPaginated(Optional<? extends IamRolesPaginated> iamRolesPaginated) {
        Utils.checkNotNull(iamRolesPaginated, "iamRolesPaginated");
        this.iamRolesPaginated = iamRolesPaginated;
        return this;
    }

    public IamListRolesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IamListRolesResponse other = (IamListRolesResponse) o;
        return 
            Objects.deepEquals(this.contentType, other.contentType) &&
            Objects.deepEquals(this.statusCode, other.statusCode) &&
            Objects.deepEquals(this.rawResponse, other.rawResponse) &&
            Objects.deepEquals(this.iamRolesPaginated, other.iamRolesPaginated) &&
            Objects.deepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            contentType,
            statusCode,
            rawResponse,
            iamRolesPaginated,
            headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IamListRolesResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "iamRolesPaginated", iamRolesPaginated,
                "headers", headers);
    }
    
    public final static class Builder {
        private Callable<Optional<IamListRolesResponse>> next;
 
        private String contentType;
 
        private Integer statusCode;
 
        private HttpResponse<InputStream> rawResponse;
 
        private Optional<? extends IamRolesPaginated> iamRolesPaginated = Optional.empty();
 
        private Map<String, List<String>> headers;  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        /**
         * The list of roles was retrieved.
         */
        public Builder iamRolesPaginated(IamRolesPaginated iamRolesPaginated) {
            Utils.checkNotNull(iamRolesPaginated, "iamRolesPaginated");
            this.iamRolesPaginated = Optional.ofNullable(iamRolesPaginated);
            return this;
        }

        /**
         * The list of roles was retrieved.
         */
        public Builder iamRolesPaginated(Optional<? extends IamRolesPaginated> iamRolesPaginated) {
            Utils.checkNotNull(iamRolesPaginated, "iamRolesPaginated");
            this.iamRolesPaginated = iamRolesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        /**
         * Internal API. Not for public use. Sets the provider of the next page.
         *
         * @Deprecated not part of the public API, may be removed without notice
         */
        @Deprecated
        public Builder next(Callable<Optional<IamListRolesResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }
        
        public IamListRolesResponse build() {
            return new IamListRolesResponse(
                contentType,
                statusCode,
                rawResponse,
                iamRolesPaginated,
                headers)
                .withNext(next);
        }
    }
}

