/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class PhoneNumberType {
    public static final PhoneNumberType PERSONAL = new PhoneNumberType("personal");
    public static final PhoneNumberType WORK = new PhoneNumberType("work");
    public static final PhoneNumberType MOBILE = new PhoneNumberType("mobile");
    public static final PhoneNumberType HOME = new PhoneNumberType("home");
    public static final PhoneNumberType UNKNOWN = new PhoneNumberType("unknown");
    public static final PhoneNumberType OTHER = new PhoneNumberType("other");
    private static final Map<String, PhoneNumberType> values = PhoneNumberType.createValuesMap();
    private static final Map<String, PhoneNumberTypeEnum> enums = PhoneNumberType.createEnumsMap();
    private final String value;

    private PhoneNumberType(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhoneNumberType of(String value) {
        Class<PhoneNumberType> clazz = PhoneNumberType.class;
        synchronized (PhoneNumberType.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new PhoneNumberType((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<PhoneNumberTypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhoneNumberType other = (PhoneNumberType)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "PhoneNumberType [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhoneNumberType[] values() {
        Class<PhoneNumberType> clazz = PhoneNumberType.class;
        synchronized (PhoneNumberType.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new PhoneNumberType[0]);
        }
    }

    private static final Map<String, PhoneNumberType> createValuesMap() {
        LinkedHashMap<String, PhoneNumberType> map = new LinkedHashMap<String, PhoneNumberType>();
        map.put("personal", PERSONAL);
        map.put("work", WORK);
        map.put("mobile", MOBILE);
        map.put("home", HOME);
        map.put("unknown", UNKNOWN);
        map.put("other", OTHER);
        return map;
    }

    private static final Map<String, PhoneNumberTypeEnum> createEnumsMap() {
        HashMap<String, PhoneNumberTypeEnum> map = new HashMap<String, PhoneNumberTypeEnum>();
        map.put("personal", PhoneNumberTypeEnum.PERSONAL);
        map.put("work", PhoneNumberTypeEnum.WORK);
        map.put("mobile", PhoneNumberTypeEnum.MOBILE);
        map.put("home", PhoneNumberTypeEnum.HOME);
        map.put("unknown", PhoneNumberTypeEnum.UNKNOWN);
        map.put("other", PhoneNumberTypeEnum.OTHER);
        return map;
    }

    public static enum PhoneNumberTypeEnum {
        PERSONAL("personal"),
        WORK("work"),
        MOBILE("mobile"),
        HOME("home"),
        UNKNOWN("unknown"),
        OTHER("other");

        private final String value;

        private PhoneNumberTypeEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<PhoneNumberType> {
        protected _Deserializer() {
            super(PhoneNumberType.class);
        }

        public PhoneNumberType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return PhoneNumberType.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<PhoneNumberType> {
        protected _Serializer() {
            super(PhoneNumberType.class);
        }

        public void serialize(PhoneNumberType value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

