/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AssessmentOrderResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AtsGetAssessmentsRequestResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AssessmentOrderResult> assessmentOrderResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetAssessmentsRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AssessmentOrderResult> assessmentOrderResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(assessmentOrderResult, "assessmentOrderResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.assessmentOrderResult = assessmentOrderResult;
        this.headers = headers;
    }

    public AtsGetAssessmentsRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AssessmentOrderResult> assessmentOrderResult() {
        return this.assessmentOrderResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsGetAssessmentsRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetAssessmentsRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetAssessmentsRequestResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetAssessmentsRequestResponse withAssessmentOrderResult(AssessmentOrderResult assessmentOrderResult) {
        Utils.checkNotNull(assessmentOrderResult, "assessmentOrderResult");
        this.assessmentOrderResult = Optional.ofNullable(assessmentOrderResult);
        return this;
    }

    public AtsGetAssessmentsRequestResponse withAssessmentOrderResult(Optional<? extends AssessmentOrderResult> assessmentOrderResult) {
        Utils.checkNotNull(assessmentOrderResult, "assessmentOrderResult");
        this.assessmentOrderResult = assessmentOrderResult;
        return this;
    }

    public AtsGetAssessmentsRequestResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetAssessmentsRequestResponse other = (AtsGetAssessmentsRequestResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.assessmentOrderResult, other.assessmentOrderResult) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.assessmentOrderResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetAssessmentsRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "assessmentOrderResult", this.assessmentOrderResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AssessmentOrderResult> assessmentOrderResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder assessmentOrderResult(AssessmentOrderResult assessmentOrderResult) {
            Utils.checkNotNull(assessmentOrderResult, "assessmentOrderResult");
            this.assessmentOrderResult = Optional.ofNullable(assessmentOrderResult);
            return this;
        }

        public Builder assessmentOrderResult(Optional<? extends AssessmentOrderResult> assessmentOrderResult) {
            Utils.checkNotNull(assessmentOrderResult, "assessmentOrderResult");
            this.assessmentOrderResult = assessmentOrderResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetAssessmentsRequestResponse build() {
            return new AtsGetAssessmentsRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.assessmentOrderResult, this.headers);
        }
    }
}

