/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class EmploymentContractTypeValue {
    public static final EmploymentContractTypeValue FULL_TIME = new EmploymentContractTypeValue("full_time");
    public static final EmploymentContractTypeValue SHIFTS = new EmploymentContractTypeValue("shifts");
    public static final EmploymentContractTypeValue PART_TIME = new EmploymentContractTypeValue("part_time");
    public static final EmploymentContractTypeValue UNMAPPED_VALUE = new EmploymentContractTypeValue("unmapped_value");
    private static final Map<String, EmploymentContractTypeValue> values = EmploymentContractTypeValue.createValuesMap();
    private static final Map<String, EmploymentContractTypeValueEnum> enums = EmploymentContractTypeValue.createEnumsMap();
    private final String value;

    private EmploymentContractTypeValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmploymentContractTypeValue of(String value) {
        Class<EmploymentContractTypeValue> clazz = EmploymentContractTypeValue.class;
        synchronized (EmploymentContractTypeValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmploymentContractTypeValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<EmploymentContractTypeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmploymentContractTypeValue other = (EmploymentContractTypeValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmploymentContractTypeValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmploymentContractTypeValue[] values() {
        Class<EmploymentContractTypeValue> clazz = EmploymentContractTypeValue.class;
        synchronized (EmploymentContractTypeValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmploymentContractTypeValue[0]);
        }
    }

    private static final Map<String, EmploymentContractTypeValue> createValuesMap() {
        LinkedHashMap<String, EmploymentContractTypeValue> map = new LinkedHashMap<String, EmploymentContractTypeValue>();
        map.put("full_time", FULL_TIME);
        map.put("shifts", SHIFTS);
        map.put("part_time", PART_TIME);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, EmploymentContractTypeValueEnum> createEnumsMap() {
        HashMap<String, EmploymentContractTypeValueEnum> map = new HashMap<String, EmploymentContractTypeValueEnum>();
        map.put("full_time", EmploymentContractTypeValueEnum.FULL_TIME);
        map.put("shifts", EmploymentContractTypeValueEnum.SHIFTS);
        map.put("part_time", EmploymentContractTypeValueEnum.PART_TIME);
        map.put("unmapped_value", EmploymentContractTypeValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum EmploymentContractTypeValueEnum {
        FULL_TIME("full_time"),
        SHIFTS("shifts"),
        PART_TIME("part_time"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private EmploymentContractTypeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<EmploymentContractTypeValue> {
        protected _Deserializer() {
            super(EmploymentContractTypeValue.class);
        }

        public EmploymentContractTypeValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return EmploymentContractTypeValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<EmploymentContractTypeValue> {
        protected _Serializer() {
            super(EmploymentContractTypeValue.class);
        }

        public void serialize(EmploymentContractTypeValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

