/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.components.CrmCreateContactRequestDto;
import com.stackone.stackone_client_java.models.operations.CrmCreateContactRequest;
import com.stackone.stackone_client_java.models.operations.CrmGetAccountRequest;
import com.stackone.stackone_client_java.models.operations.CrmGetContactCustomFieldDefinitionRequest;
import com.stackone.stackone_client_java.models.operations.CrmGetContactRequest;
import com.stackone.stackone_client_java.models.operations.CrmGetListRequest;
import com.stackone.stackone_client_java.models.operations.CrmListAccountsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListContactCustomFieldDefinitionsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListContactsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListListsRequest;
import com.stackone.stackone_client_java.models.operations.CrmUpdateContactRequest;
import com.stackone.stackone_client_java.models.operations.async.CrmCreateContactRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.CrmCreateContactResponse;
import com.stackone.stackone_client_java.models.operations.async.CrmGetAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.CrmGetAccountResponse;
import com.stackone.stackone_client_java.models.operations.async.CrmGetContactCustomFieldDefinitionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.CrmGetContactCustomFieldDefinitionResponse;
import com.stackone.stackone_client_java.models.operations.async.CrmGetContactRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.CrmGetContactResponse;
import com.stackone.stackone_client_java.models.operations.async.CrmGetListRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.CrmGetListResponse;
import com.stackone.stackone_client_java.models.operations.async.CrmListAccountsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.CrmListAccountsResponse;
import com.stackone.stackone_client_java.models.operations.async.CrmListContactCustomFieldDefinitionsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.CrmListContactCustomFieldDefinitionsResponse;
import com.stackone.stackone_client_java.models.operations.async.CrmListContactsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.CrmListContactsResponse;
import com.stackone.stackone_client_java.models.operations.async.CrmListListsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.CrmListListsResponse;
import com.stackone.stackone_client_java.models.operations.async.CrmUpdateContactRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.CrmUpdateContactResponse;
import com.stackone.stackone_client_java.operations.CrmCreateContact;
import com.stackone.stackone_client_java.operations.CrmGetAccount;
import com.stackone.stackone_client_java.operations.CrmGetContact;
import com.stackone.stackone_client_java.operations.CrmGetContactCustomFieldDefinition;
import com.stackone.stackone_client_java.operations.CrmGetList;
import com.stackone.stackone_client_java.operations.CrmListAccounts;
import com.stackone.stackone_client_java.operations.CrmListContactCustomFieldDefinitions;
import com.stackone.stackone_client_java.operations.CrmListContacts;
import com.stackone.stackone_client_java.operations.CrmListLists;
import com.stackone.stackone_client_java.operations.CrmUpdateContact;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;


public class AsyncCrm {
    private final SDKConfiguration sdkConfiguration;
    private final Crm syncSDK;

    AsyncCrm(Crm syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Crm sync() {
        return syncSDK;
    }


    /**
     * List Contacts
     * 
     * @return The async call builder
     */
    public CrmListContactsRequestBuilder listContacts() {
        return new CrmListContactsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Contacts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;CrmListContactsResponse&gt; - The async response
     */
    public CompletableFuture<CrmListContactsResponse> listContacts(CrmListContactsRequest request) {
        return listContacts(request, Optional.empty());
    }

    /**
     * List Contacts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;CrmListContactsResponse&gt; - The async response
     */
    public CompletableFuture<CrmListContactsResponse> listContacts(CrmListContactsRequest request, Optional<Options> options) {
        AsyncRequestOperation<CrmListContactsRequest, CrmListContactsResponse> operation
              = new CrmListContacts.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Create Contact
     * 
     * @return The async call builder
     */
    public CrmCreateContactRequestBuilder createContact() {
        return new CrmCreateContactRequestBuilder(sdkConfiguration);
    }

    /**
     * Create Contact
     * 
     * @param xAccountId The account identifier
     * @param crmCreateContactRequestDto 
     * @return CompletableFuture&lt;CrmCreateContactResponse&gt; - The async response
     */
    public CompletableFuture<CrmCreateContactResponse> createContact(String xAccountId, CrmCreateContactRequestDto crmCreateContactRequestDto) {
        return createContact(xAccountId, crmCreateContactRequestDto, Optional.empty());
    }

    /**
     * Create Contact
     * 
     * @param xAccountId The account identifier
     * @param crmCreateContactRequestDto 
     * @param options additional options
     * @return CompletableFuture&lt;CrmCreateContactResponse&gt; - The async response
     */
    public CompletableFuture<CrmCreateContactResponse> createContact(
            String xAccountId, CrmCreateContactRequestDto crmCreateContactRequestDto,
            Optional<Options> options) {
        CrmCreateContactRequest request =
            CrmCreateContactRequest
                .builder()
                .xAccountId(xAccountId)
                .crmCreateContactRequestDto(crmCreateContactRequestDto)
                .build();
        AsyncRequestOperation<CrmCreateContactRequest, CrmCreateContactResponse> operation
              = new CrmCreateContact.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Contact
     * 
     * @return The async call builder
     */
    public CrmGetContactRequestBuilder getContact() {
        return new CrmGetContactRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Contact
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;CrmGetContactResponse&gt; - The async response
     */
    public CompletableFuture<CrmGetContactResponse> getContact(CrmGetContactRequest request) {
        return getContact(request, Optional.empty());
    }

    /**
     * Get Contact
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;CrmGetContactResponse&gt; - The async response
     */
    public CompletableFuture<CrmGetContactResponse> getContact(CrmGetContactRequest request, Optional<Options> options) {
        AsyncRequestOperation<CrmGetContactRequest, CrmGetContactResponse> operation
              = new CrmGetContact.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Update Contact (early access)
     * 
     * @return The async call builder
     */
    public CrmUpdateContactRequestBuilder updateContact() {
        return new CrmUpdateContactRequestBuilder(sdkConfiguration);
    }

    /**
     * Update Contact (early access)
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param crmCreateContactRequestDto 
     * @return CompletableFuture&lt;CrmUpdateContactResponse&gt; - The async response
     */
    public CompletableFuture<CrmUpdateContactResponse> updateContact(
            String xAccountId, String id,
            CrmCreateContactRequestDto crmCreateContactRequestDto) {
        return updateContact(
                xAccountId, id, crmCreateContactRequestDto,
                Optional.empty());
    }

    /**
     * Update Contact (early access)
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param crmCreateContactRequestDto 
     * @param options additional options
     * @return CompletableFuture&lt;CrmUpdateContactResponse&gt; - The async response
     */
    public CompletableFuture<CrmUpdateContactResponse> updateContact(
            String xAccountId, String id,
            CrmCreateContactRequestDto crmCreateContactRequestDto, Optional<Options> options) {
        CrmUpdateContactRequest request =
            CrmUpdateContactRequest
                .builder()
                .xAccountId(xAccountId)
                .id(id)
                .crmCreateContactRequestDto(crmCreateContactRequestDto)
                .build();
        AsyncRequestOperation<CrmUpdateContactRequest, CrmUpdateContactResponse> operation
              = new CrmUpdateContact.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Accounts
     * 
     * @return The async call builder
     */
    public CrmListAccountsRequestBuilder listAccounts() {
        return new CrmListAccountsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Accounts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;CrmListAccountsResponse&gt; - The async response
     */
    public CompletableFuture<CrmListAccountsResponse> listAccounts(CrmListAccountsRequest request) {
        return listAccounts(request, Optional.empty());
    }

    /**
     * List Accounts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;CrmListAccountsResponse&gt; - The async response
     */
    public CompletableFuture<CrmListAccountsResponse> listAccounts(CrmListAccountsRequest request, Optional<Options> options) {
        AsyncRequestOperation<CrmListAccountsRequest, CrmListAccountsResponse> operation
              = new CrmListAccounts.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Account
     * 
     * @return The async call builder
     */
    public CrmGetAccountRequestBuilder getAccount() {
        return new CrmGetAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Account
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;CrmGetAccountResponse&gt; - The async response
     */
    public CompletableFuture<CrmGetAccountResponse> getAccount(CrmGetAccountRequest request) {
        return getAccount(request, Optional.empty());
    }

    /**
     * Get Account
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;CrmGetAccountResponse&gt; - The async response
     */
    public CompletableFuture<CrmGetAccountResponse> getAccount(CrmGetAccountRequest request, Optional<Options> options) {
        AsyncRequestOperation<CrmGetAccountRequest, CrmGetAccountResponse> operation
              = new CrmGetAccount.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get all Lists
     * 
     * @return The async call builder
     */
    public CrmListListsRequestBuilder listLists() {
        return new CrmListListsRequestBuilder(sdkConfiguration);
    }

    /**
     * Get all Lists
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;CrmListListsResponse&gt; - The async response
     */
    public CompletableFuture<CrmListListsResponse> listLists(CrmListListsRequest request) {
        return listLists(request, Optional.empty());
    }

    /**
     * Get all Lists
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;CrmListListsResponse&gt; - The async response
     */
    public CompletableFuture<CrmListListsResponse> listLists(CrmListListsRequest request, Optional<Options> options) {
        AsyncRequestOperation<CrmListListsRequest, CrmListListsResponse> operation
              = new CrmListLists.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get List
     * 
     * @return The async call builder
     */
    public CrmGetListRequestBuilder getList() {
        return new CrmGetListRequestBuilder(sdkConfiguration);
    }

    /**
     * Get List
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;CrmGetListResponse&gt; - The async response
     */
    public CompletableFuture<CrmGetListResponse> getList(CrmGetListRequest request) {
        return getList(request, Optional.empty());
    }

    /**
     * Get List
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;CrmGetListResponse&gt; - The async response
     */
    public CompletableFuture<CrmGetListResponse> getList(CrmGetListRequest request, Optional<Options> options) {
        AsyncRequestOperation<CrmGetListRequest, CrmGetListResponse> operation
              = new CrmGetList.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * List Contact Custom Field Definitions
     * 
     * @return The async call builder
     */
    public CrmListContactCustomFieldDefinitionsRequestBuilder listContactCustomFieldDefinitions() {
        return new CrmListContactCustomFieldDefinitionsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Contact Custom Field Definitions
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;CrmListContactCustomFieldDefinitionsResponse&gt; - The async response
     */
    public CompletableFuture<CrmListContactCustomFieldDefinitionsResponse> listContactCustomFieldDefinitions(CrmListContactCustomFieldDefinitionsRequest request) {
        return listContactCustomFieldDefinitions(request, Optional.empty());
    }

    /**
     * List Contact Custom Field Definitions
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;CrmListContactCustomFieldDefinitionsResponse&gt; - The async response
     */
    public CompletableFuture<CrmListContactCustomFieldDefinitionsResponse> listContactCustomFieldDefinitions(CrmListContactCustomFieldDefinitionsRequest request, Optional<Options> options) {
        AsyncRequestOperation<CrmListContactCustomFieldDefinitionsRequest, CrmListContactCustomFieldDefinitionsResponse> operation
              = new CrmListContactCustomFieldDefinitions.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Get Contact Custom Field Definition
     * 
     * @return The async call builder
     */
    public CrmGetContactCustomFieldDefinitionRequestBuilder getContactCustomFieldDefinition() {
        return new CrmGetContactCustomFieldDefinitionRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Contact Custom Field Definition
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;CrmGetContactCustomFieldDefinitionResponse&gt; - The async response
     */
    public CompletableFuture<CrmGetContactCustomFieldDefinitionResponse> getContactCustomFieldDefinition(CrmGetContactCustomFieldDefinitionRequest request) {
        return getContactCustomFieldDefinition(request, Optional.empty());
    }

    /**
     * Get Contact Custom Field Definition
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;CrmGetContactCustomFieldDefinitionResponse&gt; - The async response
     */
    public CompletableFuture<CrmGetContactCustomFieldDefinitionResponse> getContactCustomFieldDefinition(CrmGetContactCustomFieldDefinitionRequest request, Optional<Options> options) {
        AsyncRequestOperation<CrmGetContactCustomFieldDefinitionRequest, CrmGetContactCustomFieldDefinitionResponse> operation
              = new CrmGetContactCustomFieldDefinition.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
