/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class AccountingTaxRate {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * ID of the company this tax rate belongs to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("company_id")
    private JsonNullable<String> companyId;

    /**
     * Name of the tax rate
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * External system's tax code
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("code")
    private JsonNullable<String> code;

    /**
     * Tax rate percentage
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("percentage")
    private JsonNullable<Double> percentage;

    /**
     * Whether the tax rate is active
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("active")
    private JsonNullable<? extends AccountingTaxRateActive> active;

    @JsonCreator
    public AccountingTaxRate(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("company_id") JsonNullable<String> companyId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("code") JsonNullable<String> code,
            @JsonProperty("percentage") JsonNullable<Double> percentage,
            @JsonProperty("active") JsonNullable<? extends AccountingTaxRateActive> active) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(companyId, "companyId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(code, "code");
        Utils.checkNotNull(percentage, "percentage");
        Utils.checkNotNull(active, "active");
        this.id = id;
        this.remoteId = remoteId;
        this.companyId = companyId;
        this.name = name;
        this.code = code;
        this.percentage = percentage;
        this.active = active;
    }
    
    public AccountingTaxRate() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * ID of the company this tax rate belongs to
     */
    @JsonIgnore
    public JsonNullable<String> companyId() {
        return companyId;
    }

    /**
     * Name of the tax rate
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * External system's tax code
     */
    @JsonIgnore
    public JsonNullable<String> code() {
        return code;
    }

    /**
     * Tax rate percentage
     */
    @JsonIgnore
    public JsonNullable<Double> percentage() {
        return percentage;
    }

    /**
     * Whether the tax rate is active
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingTaxRateActive> active() {
        return (JsonNullable<AccountingTaxRateActive>) active;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public AccountingTaxRate withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public AccountingTaxRate withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AccountingTaxRate withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AccountingTaxRate withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * ID of the company this tax rate belongs to
     */
    public AccountingTaxRate withCompanyId(String companyId) {
        Utils.checkNotNull(companyId, "companyId");
        this.companyId = JsonNullable.of(companyId);
        return this;
    }

    /**
     * ID of the company this tax rate belongs to
     */
    public AccountingTaxRate withCompanyId(JsonNullable<String> companyId) {
        Utils.checkNotNull(companyId, "companyId");
        this.companyId = companyId;
        return this;
    }

    /**
     * Name of the tax rate
     */
    public AccountingTaxRate withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * Name of the tax rate
     */
    public AccountingTaxRate withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * External system's tax code
     */
    public AccountingTaxRate withCode(String code) {
        Utils.checkNotNull(code, "code");
        this.code = JsonNullable.of(code);
        return this;
    }

    /**
     * External system's tax code
     */
    public AccountingTaxRate withCode(JsonNullable<String> code) {
        Utils.checkNotNull(code, "code");
        this.code = code;
        return this;
    }

    /**
     * Tax rate percentage
     */
    public AccountingTaxRate withPercentage(double percentage) {
        Utils.checkNotNull(percentage, "percentage");
        this.percentage = JsonNullable.of(percentage);
        return this;
    }

    /**
     * Tax rate percentage
     */
    public AccountingTaxRate withPercentage(JsonNullable<Double> percentage) {
        Utils.checkNotNull(percentage, "percentage");
        this.percentage = percentage;
        return this;
    }

    /**
     * Whether the tax rate is active
     */
    public AccountingTaxRate withActive(AccountingTaxRateActive active) {
        Utils.checkNotNull(active, "active");
        this.active = JsonNullable.of(active);
        return this;
    }

    /**
     * Whether the tax rate is active
     */
    public AccountingTaxRate withActive(JsonNullable<? extends AccountingTaxRateActive> active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountingTaxRate other = (AccountingTaxRate) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.companyId, other.companyId) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.code, other.code) &&
            Utils.enhancedDeepEquals(this.percentage, other.percentage) &&
            Utils.enhancedDeepEquals(this.active, other.active);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, companyId,
            name, code, percentage,
            active);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountingTaxRate.class,
                "id", id,
                "remoteId", remoteId,
                "companyId", companyId,
                "name", name,
                "code", code,
                "percentage", percentage,
                "active", active);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> companyId = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<String> code = JsonNullable.undefined();

        private JsonNullable<Double> percentage = JsonNullable.undefined();

        private JsonNullable<? extends AccountingTaxRateActive> active = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * ID of the company this tax rate belongs to
         */
        public Builder companyId(String companyId) {
            Utils.checkNotNull(companyId, "companyId");
            this.companyId = JsonNullable.of(companyId);
            return this;
        }

        /**
         * ID of the company this tax rate belongs to
         */
        public Builder companyId(JsonNullable<String> companyId) {
            Utils.checkNotNull(companyId, "companyId");
            this.companyId = companyId;
            return this;
        }


        /**
         * Name of the tax rate
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * Name of the tax rate
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * External system's tax code
         */
        public Builder code(String code) {
            Utils.checkNotNull(code, "code");
            this.code = JsonNullable.of(code);
            return this;
        }

        /**
         * External system's tax code
         */
        public Builder code(JsonNullable<String> code) {
            Utils.checkNotNull(code, "code");
            this.code = code;
            return this;
        }


        /**
         * Tax rate percentage
         */
        public Builder percentage(double percentage) {
            Utils.checkNotNull(percentage, "percentage");
            this.percentage = JsonNullable.of(percentage);
            return this;
        }

        /**
         * Tax rate percentage
         */
        public Builder percentage(JsonNullable<Double> percentage) {
            Utils.checkNotNull(percentage, "percentage");
            this.percentage = percentage;
            return this;
        }


        /**
         * Whether the tax rate is active
         */
        public Builder active(AccountingTaxRateActive active) {
            Utils.checkNotNull(active, "active");
            this.active = JsonNullable.of(active);
            return this;
        }

        /**
         * Whether the tax rate is active
         */
        public Builder active(JsonNullable<? extends AccountingTaxRateActive> active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }

        public AccountingTaxRate build() {

            return new AccountingTaxRate(
                id, remoteId, companyId,
                name, code, percentage,
                active);
        }

    }
}
