/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;


public class DownloadHeadersApiModel {
    /**
     * Value of the Content-Disposition header
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content-disposition")
    private JsonNullable<String> contentDisposition;

    /**
     * MIME type of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content-type")
    private JsonNullable<String> contentType;

    /**
     * Size of the content in bytes
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content-length")
    private JsonNullable<Double> contentLength;

    /**
     * Range of the content being sent
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content-range")
    private JsonNullable<String> contentRange;

    /**
     * Encoding of the content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content-encoding")
    private JsonNullable<String> contentEncoding;

    /**
     * Transfer encoding type
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("transfer-encoding")
    private JsonNullable<String> transferEncoding;

    @JsonCreator
    public DownloadHeadersApiModel(
            @JsonProperty("content-disposition") JsonNullable<String> contentDisposition,
            @JsonProperty("content-type") JsonNullable<String> contentType,
            @JsonProperty("content-length") JsonNullable<Double> contentLength,
            @JsonProperty("content-range") JsonNullable<String> contentRange,
            @JsonProperty("content-encoding") JsonNullable<String> contentEncoding,
            @JsonProperty("transfer-encoding") JsonNullable<String> transferEncoding) {
        Utils.checkNotNull(contentDisposition, "contentDisposition");
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(contentLength, "contentLength");
        Utils.checkNotNull(contentRange, "contentRange");
        Utils.checkNotNull(contentEncoding, "contentEncoding");
        Utils.checkNotNull(transferEncoding, "transferEncoding");
        this.contentDisposition = contentDisposition;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.contentRange = contentRange;
        this.contentEncoding = contentEncoding;
        this.transferEncoding = transferEncoding;
    }
    
    public DownloadHeadersApiModel() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Value of the Content-Disposition header
     */
    @JsonIgnore
    public JsonNullable<String> contentDisposition() {
        return contentDisposition;
    }

    /**
     * MIME type of the file
     */
    @JsonIgnore
    public JsonNullable<String> contentType() {
        return contentType;
    }

    /**
     * Size of the content in bytes
     */
    @JsonIgnore
    public JsonNullable<Double> contentLength() {
        return contentLength;
    }

    /**
     * Range of the content being sent
     */
    @JsonIgnore
    public JsonNullable<String> contentRange() {
        return contentRange;
    }

    /**
     * Encoding of the content
     */
    @JsonIgnore
    public JsonNullable<String> contentEncoding() {
        return contentEncoding;
    }

    /**
     * Transfer encoding type
     */
    @JsonIgnore
    public JsonNullable<String> transferEncoding() {
        return transferEncoding;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Value of the Content-Disposition header
     */
    public DownloadHeadersApiModel withContentDisposition(String contentDisposition) {
        Utils.checkNotNull(contentDisposition, "contentDisposition");
        this.contentDisposition = JsonNullable.of(contentDisposition);
        return this;
    }

    /**
     * Value of the Content-Disposition header
     */
    public DownloadHeadersApiModel withContentDisposition(JsonNullable<String> contentDisposition) {
        Utils.checkNotNull(contentDisposition, "contentDisposition");
        this.contentDisposition = contentDisposition;
        return this;
    }

    /**
     * MIME type of the file
     */
    public DownloadHeadersApiModel withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = JsonNullable.of(contentType);
        return this;
    }

    /**
     * MIME type of the file
     */
    public DownloadHeadersApiModel withContentType(JsonNullable<String> contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * Size of the content in bytes
     */
    public DownloadHeadersApiModel withContentLength(double contentLength) {
        Utils.checkNotNull(contentLength, "contentLength");
        this.contentLength = JsonNullable.of(contentLength);
        return this;
    }

    /**
     * Size of the content in bytes
     */
    public DownloadHeadersApiModel withContentLength(JsonNullable<Double> contentLength) {
        Utils.checkNotNull(contentLength, "contentLength");
        this.contentLength = contentLength;
        return this;
    }

    /**
     * Range of the content being sent
     */
    public DownloadHeadersApiModel withContentRange(String contentRange) {
        Utils.checkNotNull(contentRange, "contentRange");
        this.contentRange = JsonNullable.of(contentRange);
        return this;
    }

    /**
     * Range of the content being sent
     */
    public DownloadHeadersApiModel withContentRange(JsonNullable<String> contentRange) {
        Utils.checkNotNull(contentRange, "contentRange");
        this.contentRange = contentRange;
        return this;
    }

    /**
     * Encoding of the content
     */
    public DownloadHeadersApiModel withContentEncoding(String contentEncoding) {
        Utils.checkNotNull(contentEncoding, "contentEncoding");
        this.contentEncoding = JsonNullable.of(contentEncoding);
        return this;
    }

    /**
     * Encoding of the content
     */
    public DownloadHeadersApiModel withContentEncoding(JsonNullable<String> contentEncoding) {
        Utils.checkNotNull(contentEncoding, "contentEncoding");
        this.contentEncoding = contentEncoding;
        return this;
    }

    /**
     * Transfer encoding type
     */
    public DownloadHeadersApiModel withTransferEncoding(String transferEncoding) {
        Utils.checkNotNull(transferEncoding, "transferEncoding");
        this.transferEncoding = JsonNullable.of(transferEncoding);
        return this;
    }

    /**
     * Transfer encoding type
     */
    public DownloadHeadersApiModel withTransferEncoding(JsonNullable<String> transferEncoding) {
        Utils.checkNotNull(transferEncoding, "transferEncoding");
        this.transferEncoding = transferEncoding;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DownloadHeadersApiModel other = (DownloadHeadersApiModel) o;
        return 
            Utils.enhancedDeepEquals(this.contentDisposition, other.contentDisposition) &&
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.contentLength, other.contentLength) &&
            Utils.enhancedDeepEquals(this.contentRange, other.contentRange) &&
            Utils.enhancedDeepEquals(this.contentEncoding, other.contentEncoding) &&
            Utils.enhancedDeepEquals(this.transferEncoding, other.transferEncoding);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentDisposition, contentType, contentLength,
            contentRange, contentEncoding, transferEncoding);
    }
    
    @Override
    public String toString() {
        return Utils.toString(DownloadHeadersApiModel.class,
                "contentDisposition", contentDisposition,
                "contentType", contentType,
                "contentLength", contentLength,
                "contentRange", contentRange,
                "contentEncoding", contentEncoding,
                "transferEncoding", transferEncoding);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> contentDisposition = JsonNullable.undefined();

        private JsonNullable<String> contentType = JsonNullable.undefined();

        private JsonNullable<Double> contentLength = JsonNullable.undefined();

        private JsonNullable<String> contentRange = JsonNullable.undefined();

        private JsonNullable<String> contentEncoding = JsonNullable.undefined();

        private JsonNullable<String> transferEncoding = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Value of the Content-Disposition header
         */
        public Builder contentDisposition(String contentDisposition) {
            Utils.checkNotNull(contentDisposition, "contentDisposition");
            this.contentDisposition = JsonNullable.of(contentDisposition);
            return this;
        }

        /**
         * Value of the Content-Disposition header
         */
        public Builder contentDisposition(JsonNullable<String> contentDisposition) {
            Utils.checkNotNull(contentDisposition, "contentDisposition");
            this.contentDisposition = contentDisposition;
            return this;
        }


        /**
         * MIME type of the file
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = JsonNullable.of(contentType);
            return this;
        }

        /**
         * MIME type of the file
         */
        public Builder contentType(JsonNullable<String> contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * Size of the content in bytes
         */
        public Builder contentLength(double contentLength) {
            Utils.checkNotNull(contentLength, "contentLength");
            this.contentLength = JsonNullable.of(contentLength);
            return this;
        }

        /**
         * Size of the content in bytes
         */
        public Builder contentLength(JsonNullable<Double> contentLength) {
            Utils.checkNotNull(contentLength, "contentLength");
            this.contentLength = contentLength;
            return this;
        }


        /**
         * Range of the content being sent
         */
        public Builder contentRange(String contentRange) {
            Utils.checkNotNull(contentRange, "contentRange");
            this.contentRange = JsonNullable.of(contentRange);
            return this;
        }

        /**
         * Range of the content being sent
         */
        public Builder contentRange(JsonNullable<String> contentRange) {
            Utils.checkNotNull(contentRange, "contentRange");
            this.contentRange = contentRange;
            return this;
        }


        /**
         * Encoding of the content
         */
        public Builder contentEncoding(String contentEncoding) {
            Utils.checkNotNull(contentEncoding, "contentEncoding");
            this.contentEncoding = JsonNullable.of(contentEncoding);
            return this;
        }

        /**
         * Encoding of the content
         */
        public Builder contentEncoding(JsonNullable<String> contentEncoding) {
            Utils.checkNotNull(contentEncoding, "contentEncoding");
            this.contentEncoding = contentEncoding;
            return this;
        }


        /**
         * Transfer encoding type
         */
        public Builder transferEncoding(String transferEncoding) {
            Utils.checkNotNull(transferEncoding, "transferEncoding");
            this.transferEncoding = JsonNullable.of(transferEncoding);
            return this;
        }

        /**
         * Transfer encoding type
         */
        public Builder transferEncoding(JsonNullable<String> transferEncoding) {
            Utils.checkNotNull(transferEncoding, "transferEncoding");
            this.transferEncoding = transferEncoding;
            return this;
        }

        public DownloadHeadersApiModel build() {

            return new DownloadHeadersApiModel(
                contentDisposition, contentType, contentLength,
                contentRange, contentEncoding, transferEncoding);
        }

    }
}
