/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.StackoneListConnectorsMetaRequest;
import com.stackone.stackone_client_java.operations.StackoneListConnectorsMeta;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.openapitools.jackson.nullable.JsonNullable;

public class StackoneListConnectorsMetaRequestBuilder {

    private JsonNullable<String> include = JsonNullable.undefined();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public StackoneListConnectorsMetaRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneListConnectorsMetaRequestBuilder include(String include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of(include);
        return this;
    }

    public StackoneListConnectorsMetaRequestBuilder include(JsonNullable<String> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }
                
    public StackoneListConnectorsMetaRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneListConnectorsMetaRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private StackoneListConnectorsMetaRequest buildRequest() {

        StackoneListConnectorsMetaRequest request = new StackoneListConnectorsMetaRequest(include);

        return request;
    }

    public CompletableFuture<StackoneListConnectorsMetaResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<StackoneListConnectorsMetaRequest, StackoneListConnectorsMetaResponse> operation
              = new StackoneListConnectorsMeta.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        StackoneListConnectorsMetaRequest request = buildRequest();

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
