/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.IamListPoliciesRequest;
import com.stackone.stackone_client_java.models.operations.IamListPoliciesResponse;
import com.stackone.stackone_client_java.operations.IamListPolicies;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class IamListPoliciesRequestBuilder {
    private IamListPoliciesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public IamListPoliciesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public IamListPoliciesRequestBuilder request(IamListPoliciesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public IamListPoliciesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public IamListPoliciesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public IamListPoliciesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        IamListPolicies.Sync operation = new IamListPolicies.Sync(this.sdkConfiguration, options);
        return (IamListPoliciesResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<IamListPoliciesResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        IamListPolicies.Sync operation = new IamListPolicies.Sync(this.sdkConfiguration, options);
        Paginator<IamListPoliciesRequest, String> iterator = new Paginator<IamListPoliciesRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), IamListPoliciesRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<IamListPoliciesResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

