/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.LmsGetContentRequest;
import com.stackone.stackone_client_java.models.operations.async.LmsGetContentResponse;
import com.stackone.stackone_client_java.operations.LmsGetContent;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class LmsGetContentRequestBuilder {
    private LmsGetContentRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public LmsGetContentRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public LmsGetContentRequestBuilder request(LmsGetContentRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public LmsGetContentRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsGetContentRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<LmsGetContentResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsGetContent.Async operation = new LmsGetContent.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        return operation.doRequest(this.request).thenCompose(operation::handleResponse);
    }
}

