/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.LmsListCoursesRequest;
import com.stackone.stackone_client_java.models.operations.async.LmsListCoursesResponse;
import com.stackone.stackone_client_java.operations.LmsListCourses;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.reactive.ReactiveUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class LmsListCoursesRequestBuilder {
    private LmsListCoursesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public LmsListCoursesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public LmsListCoursesRequestBuilder request(LmsListCoursesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public LmsListCoursesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsListCoursesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<LmsListCoursesResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListCourses.Async operation = new LmsListCourses.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        return operation.doRequest(this.request).thenCompose(operation::handleResponse);
    }

    public Publisher<LmsListCoursesResponse> callAsPublisher() {
        LmsListCoursesRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListCourses.Async operation = new LmsListCourses.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        AsyncPaginator<LmsListCoursesRequest, String> asyncPaginator = new AsyncPaginator<LmsListCoursesRequest, String>(request, new CursorTracker<String>("$.next", String.class), LmsListCoursesRequest::withNext, operation::doRequest);
        Flow.Publisher flowPublisher = ReactiveUtils.mapAsync(asyncPaginator, operation::handleResponse);
        return FlowAdapters.toPublisher(flowPublisher);
    }
}

