/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.MessagingMessageSendRequestDto;
import com.stackone.stackone_client_java.models.operations.MessagingSendMessageRequest;
import com.stackone.stackone_client_java.models.operations.async.MessagingSendMessageResponse;
import com.stackone.stackone_client_java.operations.MessagingSendMessage;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class MessagingSendMessageRequestBuilder {
    private String xAccountId;
    private MessagingMessageSendRequestDto messagingMessageSendRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public MessagingSendMessageRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public MessagingSendMessageRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MessagingSendMessageRequestBuilder messagingMessageSendRequestDto(MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
        Utils.checkNotNull(messagingMessageSendRequestDto, "messagingMessageSendRequestDto");
        this.messagingMessageSendRequestDto = messagingMessageSendRequestDto;
        return this;
    }

    public MessagingSendMessageRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public MessagingSendMessageRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private MessagingSendMessageRequest buildRequest() {
        MessagingSendMessageRequest request = new MessagingSendMessageRequest(this.xAccountId, this.messagingMessageSendRequestDto);
        return request;
    }

    public CompletableFuture<MessagingSendMessageResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MessagingSendMessage.Async operation = new MessagingSendMessage.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        MessagingSendMessageRequest request = this.buildRequest();
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

