/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * HrisListShiftsQueryParamFilter
 * 
 * <p>HRIS Shifts filters
 */
public class HrisListShiftsQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<OffsetDateTime> updatedAfter;

    /**
     * Filter to select shifts by status
     */
    @SpeakeasyMetadata("queryParam:name=status")
    private JsonNullable<? extends HrisListShiftsQueryParamStatus> status;

    /**
     * Filter shifts that start after this date
     */
    @SpeakeasyMetadata("queryParam:name=starts_after")
    private JsonNullable<OffsetDateTime> startsAfter;

    /**
     * Filter shifts that end before this date
     */
    @SpeakeasyMetadata("queryParam:name=ends_before")
    private JsonNullable<OffsetDateTime> endsBefore;

    @JsonCreator
    public HrisListShiftsQueryParamFilter(
            JsonNullable<OffsetDateTime> updatedAfter,
            JsonNullable<? extends HrisListShiftsQueryParamStatus> status,
            JsonNullable<OffsetDateTime> startsAfter,
            JsonNullable<OffsetDateTime> endsBefore) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(startsAfter, "startsAfter");
        Utils.checkNotNull(endsBefore, "endsBefore");
        this.updatedAfter = updatedAfter;
        this.status = status;
        this.startsAfter = startsAfter;
        this.endsBefore = endsBefore;
    }
    
    public HrisListShiftsQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Filter to select shifts by status
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisListShiftsQueryParamStatus> status() {
        return (JsonNullable<HrisListShiftsQueryParamStatus>) status;
    }

    /**
     * Filter shifts that start after this date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startsAfter() {
        return startsAfter;
    }

    /**
     * Filter shifts that end before this date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> endsBefore() {
        return endsBefore;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListShiftsQueryParamFilter withUpdatedAfter(OffsetDateTime updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListShiftsQueryParamFilter withUpdatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Filter to select shifts by status
     */
    public HrisListShiftsQueryParamFilter withStatus(HrisListShiftsQueryParamStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * Filter to select shifts by status
     */
    public HrisListShiftsQueryParamFilter withStatus(JsonNullable<? extends HrisListShiftsQueryParamStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * Filter shifts that start after this date
     */
    public HrisListShiftsQueryParamFilter withStartsAfter(OffsetDateTime startsAfter) {
        Utils.checkNotNull(startsAfter, "startsAfter");
        this.startsAfter = JsonNullable.of(startsAfter);
        return this;
    }

    /**
     * Filter shifts that start after this date
     */
    public HrisListShiftsQueryParamFilter withStartsAfter(JsonNullable<OffsetDateTime> startsAfter) {
        Utils.checkNotNull(startsAfter, "startsAfter");
        this.startsAfter = startsAfter;
        return this;
    }

    /**
     * Filter shifts that end before this date
     */
    public HrisListShiftsQueryParamFilter withEndsBefore(OffsetDateTime endsBefore) {
        Utils.checkNotNull(endsBefore, "endsBefore");
        this.endsBefore = JsonNullable.of(endsBefore);
        return this;
    }

    /**
     * Filter shifts that end before this date
     */
    public HrisListShiftsQueryParamFilter withEndsBefore(JsonNullable<OffsetDateTime> endsBefore) {
        Utils.checkNotNull(endsBefore, "endsBefore");
        this.endsBefore = endsBefore;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisListShiftsQueryParamFilter other = (HrisListShiftsQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.startsAfter, other.startsAfter) &&
            Utils.enhancedDeepEquals(this.endsBefore, other.endsBefore);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, status, startsAfter,
            endsBefore);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisListShiftsQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "status", status,
                "startsAfter", startsAfter,
                "endsBefore", endsBefore);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.undefined();

        private JsonNullable<? extends HrisListShiftsQueryParamStatus> status = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> startsAfter = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> endsBefore = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(OffsetDateTime updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * Filter to select shifts by status
         */
        public Builder status(HrisListShiftsQueryParamStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * Filter to select shifts by status
         */
        public Builder status(JsonNullable<? extends HrisListShiftsQueryParamStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * Filter shifts that start after this date
         */
        public Builder startsAfter(OffsetDateTime startsAfter) {
            Utils.checkNotNull(startsAfter, "startsAfter");
            this.startsAfter = JsonNullable.of(startsAfter);
            return this;
        }

        /**
         * Filter shifts that start after this date
         */
        public Builder startsAfter(JsonNullable<OffsetDateTime> startsAfter) {
            Utils.checkNotNull(startsAfter, "startsAfter");
            this.startsAfter = startsAfter;
            return this;
        }


        /**
         * Filter shifts that end before this date
         */
        public Builder endsBefore(OffsetDateTime endsBefore) {
            Utils.checkNotNull(endsBefore, "endsBefore");
            this.endsBefore = JsonNullable.of(endsBefore);
            return this;
        }

        /**
         * Filter shifts that end before this date
         */
        public Builder endsBefore(JsonNullable<OffsetDateTime> endsBefore) {
            Utils.checkNotNull(endsBefore, "endsBefore");
            this.endsBefore = endsBefore;
            return this;
        }

        public HrisListShiftsQueryParamFilter build() {

            return new HrisListShiftsQueryParamFilter(
                updatedAfter, status, startsAfter,
                endsBefore);
        }

    }
}
