/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * HrisListTimeOffRequestsQueryParamFilter
 * 
 * <p>HRIS Time Off filters
 */
public class HrisListTimeOffRequestsQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<OffsetDateTime> updatedAfter;

    /**
     * List of time off policy ids to filter by.
     */
    @SpeakeasyMetadata("queryParam:name=policy_ids")
    private JsonNullable<? extends List<String>> policyIds;

    /**
     * Filter to include time off requests that start on or after this date.
     */
    @SpeakeasyMetadata("queryParam:name=start_date")
    private JsonNullable<OffsetDateTime> startDate;

    /**
     * Filter to include time off requests that end on or before this date.
     */
    @SpeakeasyMetadata("queryParam:name=end_date")
    private JsonNullable<OffsetDateTime> endDate;

    @JsonCreator
    public HrisListTimeOffRequestsQueryParamFilter(
            JsonNullable<OffsetDateTime> updatedAfter,
            JsonNullable<? extends List<String>> policyIds,
            JsonNullable<OffsetDateTime> startDate,
            JsonNullable<OffsetDateTime> endDate) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(policyIds, "policyIds");
        Utils.checkNotNull(startDate, "startDate");
        Utils.checkNotNull(endDate, "endDate");
        this.updatedAfter = updatedAfter;
        this.policyIds = policyIds;
        this.startDate = startDate;
        this.endDate = endDate;
    }
    
    public HrisListTimeOffRequestsQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAfter() {
        return updatedAfter;
    }

    /**
     * List of time off policy ids to filter by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> policyIds() {
        return (JsonNullable<List<String>>) policyIds;
    }

    /**
     * Filter to include time off requests that start on or after this date.
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startDate() {
        return startDate;
    }

    /**
     * Filter to include time off requests that end on or before this date.
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> endDate() {
        return endDate;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListTimeOffRequestsQueryParamFilter withUpdatedAfter(OffsetDateTime updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListTimeOffRequestsQueryParamFilter withUpdatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * List of time off policy ids to filter by.
     */
    public HrisListTimeOffRequestsQueryParamFilter withPolicyIds(List<String> policyIds) {
        Utils.checkNotNull(policyIds, "policyIds");
        this.policyIds = JsonNullable.of(policyIds);
        return this;
    }

    /**
     * List of time off policy ids to filter by.
     */
    public HrisListTimeOffRequestsQueryParamFilter withPolicyIds(JsonNullable<? extends List<String>> policyIds) {
        Utils.checkNotNull(policyIds, "policyIds");
        this.policyIds = policyIds;
        return this;
    }

    /**
     * Filter to include time off requests that start on or after this date.
     */
    public HrisListTimeOffRequestsQueryParamFilter withStartDate(OffsetDateTime startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = JsonNullable.of(startDate);
        return this;
    }

    /**
     * Filter to include time off requests that start on or after this date.
     */
    public HrisListTimeOffRequestsQueryParamFilter withStartDate(JsonNullable<OffsetDateTime> startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = startDate;
        return this;
    }

    /**
     * Filter to include time off requests that end on or before this date.
     */
    public HrisListTimeOffRequestsQueryParamFilter withEndDate(OffsetDateTime endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = JsonNullable.of(endDate);
        return this;
    }

    /**
     * Filter to include time off requests that end on or before this date.
     */
    public HrisListTimeOffRequestsQueryParamFilter withEndDate(JsonNullable<OffsetDateTime> endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = endDate;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisListTimeOffRequestsQueryParamFilter other = (HrisListTimeOffRequestsQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.policyIds, other.policyIds) &&
            Utils.enhancedDeepEquals(this.startDate, other.startDate) &&
            Utils.enhancedDeepEquals(this.endDate, other.endDate);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, policyIds, startDate,
            endDate);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisListTimeOffRequestsQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "policyIds", policyIds,
                "startDate", startDate,
                "endDate", endDate);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> policyIds = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> startDate = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> endDate = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(OffsetDateTime updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * List of time off policy ids to filter by.
         */
        public Builder policyIds(List<String> policyIds) {
            Utils.checkNotNull(policyIds, "policyIds");
            this.policyIds = JsonNullable.of(policyIds);
            return this;
        }

        /**
         * List of time off policy ids to filter by.
         */
        public Builder policyIds(JsonNullable<? extends List<String>> policyIds) {
            Utils.checkNotNull(policyIds, "policyIds");
            this.policyIds = policyIds;
            return this;
        }


        /**
         * Filter to include time off requests that start on or after this date.
         */
        public Builder startDate(OffsetDateTime startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = JsonNullable.of(startDate);
            return this;
        }

        /**
         * Filter to include time off requests that start on or after this date.
         */
        public Builder startDate(JsonNullable<OffsetDateTime> startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = startDate;
            return this;
        }


        /**
         * Filter to include time off requests that end on or before this date.
         */
        public Builder endDate(OffsetDateTime endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = JsonNullable.of(endDate);
            return this;
        }

        /**
         * Filter to include time off requests that end on or before this date.
         */
        public Builder endDate(JsonNullable<OffsetDateTime> endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = endDate;
            return this;
        }

        public HrisListTimeOffRequestsQueryParamFilter build() {

            return new HrisListTimeOffRequestsQueryParamFilter(
                updatedAfter, policyIds, startDate,
                endDate);
        }

    }
}
