/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingTicketsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TicketingListTicketsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TicketingTicketsPaginated> ticketingTicketsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public TicketingListTicketsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TicketingTicketsPaginated> ticketingTicketsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(ticketingTicketsPaginated, "ticketingTicketsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.ticketingTicketsPaginated = ticketingTicketsPaginated;
        this.headers = headers;
    }

    public TicketingListTicketsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TicketingTicketsPaginated> ticketingTicketsPaginated() {
        return this.ticketingTicketsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingListTicketsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public TicketingListTicketsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public TicketingListTicketsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public TicketingListTicketsResponse withTicketingTicketsPaginated(TicketingTicketsPaginated ticketingTicketsPaginated) {
        Utils.checkNotNull(ticketingTicketsPaginated, "ticketingTicketsPaginated");
        this.ticketingTicketsPaginated = Optional.ofNullable(ticketingTicketsPaginated);
        return this;
    }

    public TicketingListTicketsResponse withTicketingTicketsPaginated(Optional<? extends TicketingTicketsPaginated> ticketingTicketsPaginated) {
        Utils.checkNotNull(ticketingTicketsPaginated, "ticketingTicketsPaginated");
        this.ticketingTicketsPaginated = ticketingTicketsPaginated;
        return this;
    }

    public TicketingListTicketsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingListTicketsResponse other = (TicketingListTicketsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.ticketingTicketsPaginated, other.ticketingTicketsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.ticketingTicketsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(TicketingListTicketsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "ticketingTicketsPaginated", this.ticketingTicketsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TicketingTicketsPaginated> ticketingTicketsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder ticketingTicketsPaginated(TicketingTicketsPaginated ticketingTicketsPaginated) {
            Utils.checkNotNull(ticketingTicketsPaginated, "ticketingTicketsPaginated");
            this.ticketingTicketsPaginated = Optional.ofNullable(ticketingTicketsPaginated);
            return this;
        }

        public Builder ticketingTicketsPaginated(Optional<? extends TicketingTicketsPaginated> ticketingTicketsPaginated) {
            Utils.checkNotNull(ticketingTicketsPaginated, "ticketingTicketsPaginated");
            this.ticketingTicketsPaginated = ticketingTicketsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public TicketingListTicketsResponse build() {
            return new TicketingListTicketsResponse(this.contentType, this.statusCode, this.rawResponse, this.ticketingTicketsPaginated, this.headers);
        }
    }
}

