/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.LmsListSkillsRequest;
import com.stackone.stackone_client_java.models.operations.LmsListSkillsResponse;
import com.stackone.stackone_client_java.operations.LmsListSkills;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class LmsListSkillsRequestBuilder {
    private LmsListSkillsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public LmsListSkillsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public LmsListSkillsRequestBuilder request(LmsListSkillsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public LmsListSkillsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsListSkillsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public LmsListSkillsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListSkills.Sync operation = new LmsListSkills.Sync(this.sdkConfiguration, options, this._headers);
        return (LmsListSkillsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<LmsListSkillsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsListSkills.Sync operation = new LmsListSkills.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<LmsListSkillsRequest, String> iterator = new Paginator<LmsListSkillsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), LmsListSkillsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<LmsListSkillsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

