/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingProjectResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TicketingGetProjectResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TicketingProjectResult> ticketingProjectResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public TicketingGetProjectResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TicketingProjectResult> ticketingProjectResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(ticketingProjectResult, "ticketingProjectResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.ticketingProjectResult = ticketingProjectResult;
        this.headers = headers;
    }

    public TicketingGetProjectResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TicketingProjectResult> ticketingProjectResult() {
        return this.ticketingProjectResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingGetProjectResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public TicketingGetProjectResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public TicketingGetProjectResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public TicketingGetProjectResponse withTicketingProjectResult(TicketingProjectResult ticketingProjectResult) {
        Utils.checkNotNull(ticketingProjectResult, "ticketingProjectResult");
        this.ticketingProjectResult = Optional.ofNullable(ticketingProjectResult);
        return this;
    }

    public TicketingGetProjectResponse withTicketingProjectResult(Optional<? extends TicketingProjectResult> ticketingProjectResult) {
        Utils.checkNotNull(ticketingProjectResult, "ticketingProjectResult");
        this.ticketingProjectResult = ticketingProjectResult;
        return this;
    }

    public TicketingGetProjectResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingGetProjectResponse other = (TicketingGetProjectResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.ticketingProjectResult, other.ticketingProjectResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.ticketingProjectResult, this.headers);
    }

    public String toString() {
        return Utils.toString(TicketingGetProjectResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "ticketingProjectResult", this.ticketingProjectResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TicketingProjectResult> ticketingProjectResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder ticketingProjectResult(TicketingProjectResult ticketingProjectResult) {
            Utils.checkNotNull(ticketingProjectResult, "ticketingProjectResult");
            this.ticketingProjectResult = Optional.ofNullable(ticketingProjectResult);
            return this;
        }

        public Builder ticketingProjectResult(Optional<? extends TicketingProjectResult> ticketingProjectResult) {
            Utils.checkNotNull(ticketingProjectResult, "ticketingProjectResult");
            this.ticketingProjectResult = ticketingProjectResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public TicketingGetProjectResponse build() {
            return new TicketingGetProjectResponse(this.contentType, this.statusCode, this.rawResponse, this.ticketingProjectResult, this.headers);
        }
    }
}

