/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java;

import com.stackone.stackone_client_java.Mcp;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.JsonRpcMessageDto;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteSecurity;
import com.stackone.stackone_client_java.models.operations.StackoneMcpGetRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpGetSecurity;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostSecurity;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpDeleteRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpDeleteResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpGetRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpGetResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpPostRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpPostResponse;
import com.stackone.stackone_client_java.operations.StackoneMcpDelete;
import com.stackone.stackone_client_java.operations.StackoneMcpGet;
import com.stackone.stackone_client_java.operations.StackoneMcpPost;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncMcp {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Mcp syncSDK;

    AsyncMcp(Mcp syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    public Mcp sync() {
        return this.syncSDK;
    }

    public StackoneMcpGetRequestBuilder mcpGet() {
        return new StackoneMcpGetRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<StackoneMcpGetResponse> mcpGet(StackoneMcpGetSecurity security, String xAccountId, String mcpSessionId) {
        return this.mcpGet(security, xAccountId, mcpSessionId, Optional.empty());
    }

    public CompletableFuture<StackoneMcpGetResponse> mcpGet(StackoneMcpGetSecurity security, String xAccountId, String mcpSessionId, Optional<Options> options) {
        StackoneMcpGetRequest request = StackoneMcpGetRequest.builder().xAccountId(xAccountId).mcpSessionId(mcpSessionId).build();
        StackoneMcpGet.Async operation = new StackoneMcpGet.Async(this.sdkConfiguration, security, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public StackoneMcpPostRequestBuilder mcpPost() {
        return new StackoneMcpPostRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<StackoneMcpPostResponse> mcpPost(StackoneMcpPostSecurity security, String xAccountId, JsonRpcMessageDto jsonRpcMessageDto) {
        return this.mcpPost(security, xAccountId, Optional.empty(), jsonRpcMessageDto, Optional.empty());
    }

    public CompletableFuture<StackoneMcpPostResponse> mcpPost(StackoneMcpPostSecurity security, String xAccountId, Optional<String> mcpSessionId, JsonRpcMessageDto jsonRpcMessageDto, Optional<Options> options) {
        StackoneMcpPostRequest request = StackoneMcpPostRequest.builder().xAccountId(xAccountId).mcpSessionId(mcpSessionId).jsonRpcMessageDto(jsonRpcMessageDto).build();
        StackoneMcpPost.Async operation = new StackoneMcpPost.Async(this.sdkConfiguration, security, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public StackoneMcpDeleteRequestBuilder mcpDelete() {
        return new StackoneMcpDeleteRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<StackoneMcpDeleteResponse> mcpDelete(StackoneMcpDeleteSecurity security, String xAccountId, String mcpSessionId) {
        return this.mcpDelete(security, xAccountId, mcpSessionId, Optional.empty());
    }

    public CompletableFuture<StackoneMcpDeleteResponse> mcpDelete(StackoneMcpDeleteSecurity security, String xAccountId, String mcpSessionId, Optional<Options> options) {
        StackoneMcpDeleteRequest request = StackoneMcpDeleteRequest.builder().xAccountId(xAccountId).mcpSessionId(mcpSessionId).build();
        StackoneMcpDelete.Async operation = new StackoneMcpDelete.Async(this.sdkConfiguration, security, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

