/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ConnectSessionTokenAuthLink;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StackoneCreateConnectSessionResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends ConnectSessionTokenAuthLink> connectSessionTokenAuthLink;
    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneCreateConnectSessionResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends ConnectSessionTokenAuthLink> connectSessionTokenAuthLink, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(connectSessionTokenAuthLink, "connectSessionTokenAuthLink");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.connectSessionTokenAuthLink = connectSessionTokenAuthLink;
        this.headers = headers;
    }

    public StackoneCreateConnectSessionResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ConnectSessionTokenAuthLink> connectSessionTokenAuthLink() {
        return this.connectSessionTokenAuthLink;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StackoneCreateConnectSessionResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public StackoneCreateConnectSessionResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public StackoneCreateConnectSessionResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public StackoneCreateConnectSessionResponse withConnectSessionTokenAuthLink(ConnectSessionTokenAuthLink connectSessionTokenAuthLink) {
        Utils.checkNotNull(connectSessionTokenAuthLink, "connectSessionTokenAuthLink");
        this.connectSessionTokenAuthLink = Optional.ofNullable(connectSessionTokenAuthLink);
        return this;
    }

    public StackoneCreateConnectSessionResponse withConnectSessionTokenAuthLink(Optional<? extends ConnectSessionTokenAuthLink> connectSessionTokenAuthLink) {
        Utils.checkNotNull(connectSessionTokenAuthLink, "connectSessionTokenAuthLink");
        this.connectSessionTokenAuthLink = connectSessionTokenAuthLink;
        return this;
    }

    public StackoneCreateConnectSessionResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneCreateConnectSessionResponse other = (StackoneCreateConnectSessionResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.connectSessionTokenAuthLink, other.connectSessionTokenAuthLink) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.connectSessionTokenAuthLink, this.headers);
    }

    public String toString() {
        return Utils.toString(StackoneCreateConnectSessionResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "connectSessionTokenAuthLink", this.connectSessionTokenAuthLink, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends ConnectSessionTokenAuthLink> connectSessionTokenAuthLink = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder connectSessionTokenAuthLink(ConnectSessionTokenAuthLink connectSessionTokenAuthLink) {
            Utils.checkNotNull(connectSessionTokenAuthLink, "connectSessionTokenAuthLink");
            this.connectSessionTokenAuthLink = Optional.ofNullable(connectSessionTokenAuthLink);
            return this;
        }

        public Builder connectSessionTokenAuthLink(Optional<? extends ConnectSessionTokenAuthLink> connectSessionTokenAuthLink) {
            Utils.checkNotNull(connectSessionTokenAuthLink, "connectSessionTokenAuthLink");
            this.connectSessionTokenAuthLink = connectSessionTokenAuthLink;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneCreateConnectSessionResponse build() {
            return new StackoneCreateConnectSessionResponse(this.contentType, this.statusCode, this.rawResponse, this.connectSessionTokenAuthLink, this.headers);
        }
    }
}

