/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class ActionsRpcRequestDto {
    /**
     * The action to execute
     */
    @JsonProperty("action")
    private String action;

    /**
     * Path parameters for the action
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("path")
    private JsonNullable<? extends Map<String, Object>> path;

    /**
     * Query parameters for the action
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("query")
    private JsonNullable<? extends Map<String, Object>> query;

    /**
     * Headers for the action
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("headers")
    private JsonNullable<? extends Map<String, Object>> headers;

    /**
     * Request body for the action
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("body")
    private JsonNullable<? extends Map<String, Object>> body;

    @JsonCreator
    public ActionsRpcRequestDto(
            @JsonProperty("action") String action,
            @JsonProperty("path") JsonNullable<? extends Map<String, Object>> path,
            @JsonProperty("query") JsonNullable<? extends Map<String, Object>> query,
            @JsonProperty("headers") JsonNullable<? extends Map<String, Object>> headers,
            @JsonProperty("body") JsonNullable<? extends Map<String, Object>> body) {
        Utils.checkNotNull(action, "action");
        Utils.checkNotNull(path, "path");
        Utils.checkNotNull(query, "query");
        Utils.checkNotNull(headers, "headers");
        Utils.checkNotNull(body, "body");
        this.action = action;
        this.path = path;
        this.query = query;
        this.headers = headers;
        this.body = body;
    }
    
    public ActionsRpcRequestDto(
            String action) {
        this(action, JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The action to execute
     */
    @JsonIgnore
    public String action() {
        return action;
    }

    /**
     * Path parameters for the action
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> path() {
        return (JsonNullable<Map<String, Object>>) path;
    }

    /**
     * Query parameters for the action
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> query() {
        return (JsonNullable<Map<String, Object>>) query;
    }

    /**
     * Headers for the action
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> headers() {
        return (JsonNullable<Map<String, Object>>) headers;
    }

    /**
     * Request body for the action
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> body() {
        return (JsonNullable<Map<String, Object>>) body;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The action to execute
     */
    public ActionsRpcRequestDto withAction(String action) {
        Utils.checkNotNull(action, "action");
        this.action = action;
        return this;
    }

    /**
     * Path parameters for the action
     */
    public ActionsRpcRequestDto withPath(Map<String, Object> path) {
        Utils.checkNotNull(path, "path");
        this.path = JsonNullable.of(path);
        return this;
    }

    /**
     * Path parameters for the action
     */
    public ActionsRpcRequestDto withPath(JsonNullable<? extends Map<String, Object>> path) {
        Utils.checkNotNull(path, "path");
        this.path = path;
        return this;
    }

    /**
     * Query parameters for the action
     */
    public ActionsRpcRequestDto withQuery(Map<String, Object> query) {
        Utils.checkNotNull(query, "query");
        this.query = JsonNullable.of(query);
        return this;
    }

    /**
     * Query parameters for the action
     */
    public ActionsRpcRequestDto withQuery(JsonNullable<? extends Map<String, Object>> query) {
        Utils.checkNotNull(query, "query");
        this.query = query;
        return this;
    }

    /**
     * Headers for the action
     */
    public ActionsRpcRequestDto withHeaders(Map<String, Object> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = JsonNullable.of(headers);
        return this;
    }

    /**
     * Headers for the action
     */
    public ActionsRpcRequestDto withHeaders(JsonNullable<? extends Map<String, Object>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    /**
     * Request body for the action
     */
    public ActionsRpcRequestDto withBody(Map<String, Object> body) {
        Utils.checkNotNull(body, "body");
        this.body = JsonNullable.of(body);
        return this;
    }

    /**
     * Request body for the action
     */
    public ActionsRpcRequestDto withBody(JsonNullable<? extends Map<String, Object>> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ActionsRpcRequestDto other = (ActionsRpcRequestDto) o;
        return 
            Utils.enhancedDeepEquals(this.action, other.action) &&
            Utils.enhancedDeepEquals(this.path, other.path) &&
            Utils.enhancedDeepEquals(this.query, other.query) &&
            Utils.enhancedDeepEquals(this.headers, other.headers) &&
            Utils.enhancedDeepEquals(this.body, other.body);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            action, path, query,
            headers, body);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ActionsRpcRequestDto.class,
                "action", action,
                "path", path,
                "query", query,
                "headers", headers,
                "body", body);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String action;

        private JsonNullable<? extends Map<String, Object>> path = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> query = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> headers = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> body = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The action to execute
         */
        public Builder action(String action) {
            Utils.checkNotNull(action, "action");
            this.action = action;
            return this;
        }


        /**
         * Path parameters for the action
         */
        public Builder path(Map<String, Object> path) {
            Utils.checkNotNull(path, "path");
            this.path = JsonNullable.of(path);
            return this;
        }

        /**
         * Path parameters for the action
         */
        public Builder path(JsonNullable<? extends Map<String, Object>> path) {
            Utils.checkNotNull(path, "path");
            this.path = path;
            return this;
        }


        /**
         * Query parameters for the action
         */
        public Builder query(Map<String, Object> query) {
            Utils.checkNotNull(query, "query");
            this.query = JsonNullable.of(query);
            return this;
        }

        /**
         * Query parameters for the action
         */
        public Builder query(JsonNullable<? extends Map<String, Object>> query) {
            Utils.checkNotNull(query, "query");
            this.query = query;
            return this;
        }


        /**
         * Headers for the action
         */
        public Builder headers(Map<String, Object> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = JsonNullable.of(headers);
            return this;
        }

        /**
         * Headers for the action
         */
        public Builder headers(JsonNullable<? extends Map<String, Object>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }


        /**
         * Request body for the action
         */
        public Builder body(Map<String, Object> body) {
            Utils.checkNotNull(body, "body");
            this.body = JsonNullable.of(body);
            return this;
        }

        /**
         * Request body for the action
         */
        public Builder body(JsonNullable<? extends Map<String, Object>> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }

        public ActionsRpcRequestDto build() {

            return new ActionsRpcRequestDto(
                action, path, query,
                headers, body);
        }

    }
}
