/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class MessagingConversationResultData {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * List of participant user IDs in the conversation
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("participants")
    private JsonNullable<? extends List<String>> participants;

    /**
     * Name or title of the conversation
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * Whether the conversation is private
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("private")
    private JsonNullable<? extends MessagingConversationResultPrivate> private_;

    /**
     * Timestamp when the conversation was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * Timestamp of the last message in the conversation
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("last_message_at")
    private JsonNullable<OffsetDateTime> lastMessageAt;

    @JsonCreator
    public MessagingConversationResultData(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("participants") JsonNullable<? extends List<String>> participants,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("private") JsonNullable<? extends MessagingConversationResultPrivate> private_,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("last_message_at") JsonNullable<OffsetDateTime> lastMessageAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(participants, "participants");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(private_, "private_");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(lastMessageAt, "lastMessageAt");
        this.id = id;
        this.remoteId = remoteId;
        this.participants = participants;
        this.name = name;
        this.private_ = private_;
        this.createdAt = createdAt;
        this.lastMessageAt = lastMessageAt;
    }
    
    public MessagingConversationResultData() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * List of participant user IDs in the conversation
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> participants() {
        return (JsonNullable<List<String>>) participants;
    }

    /**
     * Name or title of the conversation
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * Whether the conversation is private
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<MessagingConversationResultPrivate> private_() {
        return (JsonNullable<MessagingConversationResultPrivate>) private_;
    }

    /**
     * Timestamp when the conversation was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * Timestamp of the last message in the conversation
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> lastMessageAt() {
        return lastMessageAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public MessagingConversationResultData withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public MessagingConversationResultData withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public MessagingConversationResultData withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public MessagingConversationResultData withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * List of participant user IDs in the conversation
     */
    public MessagingConversationResultData withParticipants(List<String> participants) {
        Utils.checkNotNull(participants, "participants");
        this.participants = JsonNullable.of(participants);
        return this;
    }

    /**
     * List of participant user IDs in the conversation
     */
    public MessagingConversationResultData withParticipants(JsonNullable<? extends List<String>> participants) {
        Utils.checkNotNull(participants, "participants");
        this.participants = participants;
        return this;
    }

    /**
     * Name or title of the conversation
     */
    public MessagingConversationResultData withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * Name or title of the conversation
     */
    public MessagingConversationResultData withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * Whether the conversation is private
     */
    public MessagingConversationResultData withPrivate(MessagingConversationResultPrivate private_) {
        Utils.checkNotNull(private_, "private_");
        this.private_ = JsonNullable.of(private_);
        return this;
    }

    /**
     * Whether the conversation is private
     */
    public MessagingConversationResultData withPrivate(JsonNullable<? extends MessagingConversationResultPrivate> private_) {
        Utils.checkNotNull(private_, "private_");
        this.private_ = private_;
        return this;
    }

    /**
     * Timestamp when the conversation was created
     */
    public MessagingConversationResultData withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * Timestamp when the conversation was created
     */
    public MessagingConversationResultData withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Timestamp of the last message in the conversation
     */
    public MessagingConversationResultData withLastMessageAt(OffsetDateTime lastMessageAt) {
        Utils.checkNotNull(lastMessageAt, "lastMessageAt");
        this.lastMessageAt = JsonNullable.of(lastMessageAt);
        return this;
    }

    /**
     * Timestamp of the last message in the conversation
     */
    public MessagingConversationResultData withLastMessageAt(JsonNullable<OffsetDateTime> lastMessageAt) {
        Utils.checkNotNull(lastMessageAt, "lastMessageAt");
        this.lastMessageAt = lastMessageAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessagingConversationResultData other = (MessagingConversationResultData) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.participants, other.participants) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.private_, other.private_) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.lastMessageAt, other.lastMessageAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, participants,
            name, private_, createdAt,
            lastMessageAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessagingConversationResultData.class,
                "id", id,
                "remoteId", remoteId,
                "participants", participants,
                "name", name,
                "private_", private_,
                "createdAt", createdAt,
                "lastMessageAt", lastMessageAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> participants = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<? extends MessagingConversationResultPrivate> private_ = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> lastMessageAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * List of participant user IDs in the conversation
         */
        public Builder participants(List<String> participants) {
            Utils.checkNotNull(participants, "participants");
            this.participants = JsonNullable.of(participants);
            return this;
        }

        /**
         * List of participant user IDs in the conversation
         */
        public Builder participants(JsonNullable<? extends List<String>> participants) {
            Utils.checkNotNull(participants, "participants");
            this.participants = participants;
            return this;
        }


        /**
         * Name or title of the conversation
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * Name or title of the conversation
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * Whether the conversation is private
         */
        public Builder private_(MessagingConversationResultPrivate private_) {
            Utils.checkNotNull(private_, "private_");
            this.private_ = JsonNullable.of(private_);
            return this;
        }

        /**
         * Whether the conversation is private
         */
        public Builder private_(JsonNullable<? extends MessagingConversationResultPrivate> private_) {
            Utils.checkNotNull(private_, "private_");
            this.private_ = private_;
            return this;
        }


        /**
         * Timestamp when the conversation was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * Timestamp when the conversation was created
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * Timestamp of the last message in the conversation
         */
        public Builder lastMessageAt(OffsetDateTime lastMessageAt) {
            Utils.checkNotNull(lastMessageAt, "lastMessageAt");
            this.lastMessageAt = JsonNullable.of(lastMessageAt);
            return this;
        }

        /**
         * Timestamp of the last message in the conversation
         */
        public Builder lastMessageAt(JsonNullable<OffsetDateTime> lastMessageAt) {
            Utils.checkNotNull(lastMessageAt, "lastMessageAt");
            this.lastMessageAt = lastMessageAt;
            return this;
        }

        public MessagingConversationResultData build() {

            return new MessagingConversationResultData(
                id, remoteId, participants,
                name, private_, createdAt,
                lastMessageAt);
        }

    }
}
