/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ProxyRequestBody;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class StackoneProxyRequestRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * The request body
     */
    @SpeakeasyMetadata("request:mediaType=application/json")
    private ProxyRequestBody proxyRequestBody;

    @JsonCreator
    public StackoneProxyRequestRequest(
            String xAccountId,
            ProxyRequestBody proxyRequestBody) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
        this.xAccountId = xAccountId;
        this.proxyRequestBody = proxyRequestBody;
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * The request body
     */
    @JsonIgnore
    public ProxyRequestBody proxyRequestBody() {
        return proxyRequestBody;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public StackoneProxyRequestRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * The request body
     */
    public StackoneProxyRequestRequest withProxyRequestBody(ProxyRequestBody proxyRequestBody) {
        Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
        this.proxyRequestBody = proxyRequestBody;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneProxyRequestRequest other = (StackoneProxyRequestRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.proxyRequestBody, other.proxyRequestBody);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, proxyRequestBody);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneProxyRequestRequest.class,
                "xAccountId", xAccountId,
                "proxyRequestBody", proxyRequestBody);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private ProxyRequestBody proxyRequestBody;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * The request body
         */
        public Builder proxyRequestBody(ProxyRequestBody proxyRequestBody) {
            Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
            this.proxyRequestBody = proxyRequestBody;
            return this;
        }

        public StackoneProxyRequestRequest build() {

            return new StackoneProxyRequestRequest(
                xAccountId, proxyRequestBody);
        }

    }
}
