/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ReferencePaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListTimeOffTypesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ReferencePaginated> referencePaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListTimeOffTypesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ReferencePaginated> referencePaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(referencePaginated, "referencePaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.referencePaginated = referencePaginated;
        this.headers = headers;
    }

    public HrisListTimeOffTypesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ReferencePaginated> referencePaginated() {
        return this.referencePaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListTimeOffTypesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListTimeOffTypesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListTimeOffTypesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListTimeOffTypesResponse withReferencePaginated(ReferencePaginated referencePaginated) {
        Utils.checkNotNull(referencePaginated, "referencePaginated");
        this.referencePaginated = Optional.ofNullable(referencePaginated);
        return this;
    }

    public HrisListTimeOffTypesResponse withReferencePaginated(Optional<? extends ReferencePaginated> referencePaginated) {
        Utils.checkNotNull(referencePaginated, "referencePaginated");
        this.referencePaginated = referencePaginated;
        return this;
    }

    public HrisListTimeOffTypesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListTimeOffTypesResponse other = (HrisListTimeOffTypesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.referencePaginated, other.referencePaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.referencePaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListTimeOffTypesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "referencePaginated", this.referencePaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ReferencePaginated> referencePaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder referencePaginated(ReferencePaginated referencePaginated) {
            Utils.checkNotNull(referencePaginated, "referencePaginated");
            this.referencePaginated = Optional.ofNullable(referencePaginated);
            return this;
        }

        public Builder referencePaginated(Optional<? extends ReferencePaginated> referencePaginated) {
            Utils.checkNotNull(referencePaginated, "referencePaginated");
            this.referencePaginated = referencePaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListTimeOffTypesResponse build() {
            return new HrisListTimeOffTypesResponse(this.contentType, this.statusCode, this.rawResponse, this.referencePaginated, this.headers);
        }
    }
}

