/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;

public class StackoneMcpDeleteRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=mcp-session-id")
    private String mcpSessionId;

    @JsonCreator
    public StackoneMcpDeleteRequest(String xAccountId, String mcpSessionId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.xAccountId = xAccountId;
        this.mcpSessionId = mcpSessionId;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String mcpSessionId() {
        return this.mcpSessionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StackoneMcpDeleteRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public StackoneMcpDeleteRequest withMcpSessionId(String mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = mcpSessionId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneMcpDeleteRequest other = (StackoneMcpDeleteRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.mcpSessionId, other.mcpSessionId);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.mcpSessionId);
    }

    public String toString() {
        return Utils.toString(StackoneMcpDeleteRequest.class, "xAccountId", this.xAccountId, "mcpSessionId", this.mcpSessionId);
    }

    public static final class Builder {
        private String xAccountId;
        private String mcpSessionId;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder mcpSessionId(String mcpSessionId) {
            Utils.checkNotNull(mcpSessionId, "mcpSessionId");
            this.mcpSessionId = mcpSessionId;
            return this;
        }

        public StackoneMcpDeleteRequest build() {
            return new StackoneMcpDeleteRequest(this.xAccountId, this.mcpSessionId);
        }
    }
}

