/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class TaskResultValue {
    public static final TaskResultValue ACTION = new TaskResultValue("action");
    public static final TaskResultValue REVIEW = new TaskResultValue("review");
    public static final TaskResultValue ACKNOWLEDGMENT = new TaskResultValue("acknowledgment");
    public static final TaskResultValue EDIT = new TaskResultValue("edit");
    public static final TaskResultValue APPROVE = new TaskResultValue("approve");
    public static final TaskResultValue UNMAPPED_VALUE = new TaskResultValue("unmapped_value");
    private static final Map<String, TaskResultValue> values = TaskResultValue.createValuesMap();
    private static final Map<String, TaskResultValueEnum> enums = TaskResultValue.createEnumsMap();
    private final String value;

    private TaskResultValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskResultValue of(String value) {
        Class<TaskResultValue> clazz = TaskResultValue.class;
        synchronized (TaskResultValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TaskResultValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<TaskResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskResultValue other = (TaskResultValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TaskResultValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskResultValue[] values() {
        Class<TaskResultValue> clazz = TaskResultValue.class;
        synchronized (TaskResultValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TaskResultValue[0]);
        }
    }

    private static final Map<String, TaskResultValue> createValuesMap() {
        LinkedHashMap<String, TaskResultValue> map = new LinkedHashMap<String, TaskResultValue>();
        map.put("action", ACTION);
        map.put("review", REVIEW);
        map.put("acknowledgment", ACKNOWLEDGMENT);
        map.put("edit", EDIT);
        map.put("approve", APPROVE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TaskResultValueEnum> createEnumsMap() {
        HashMap<String, TaskResultValueEnum> map = new HashMap<String, TaskResultValueEnum>();
        map.put("action", TaskResultValueEnum.ACTION);
        map.put("review", TaskResultValueEnum.REVIEW);
        map.put("acknowledgment", TaskResultValueEnum.ACKNOWLEDGMENT);
        map.put("edit", TaskResultValueEnum.EDIT);
        map.put("approve", TaskResultValueEnum.APPROVE);
        map.put("unmapped_value", TaskResultValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TaskResultValueEnum {
        ACTION("action"),
        REVIEW("review"),
        ACKNOWLEDGMENT("acknowledgment"),
        EDIT("edit"),
        APPROVE("approve"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TaskResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<TaskResultValue> {
        protected _Deserializer() {
            super(TaskResultValue.class);
        }

        public TaskResultValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return TaskResultValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<TaskResultValue> {
        protected _Serializer() {
            super(TaskResultValue.class);
        }

        public void serialize(TaskResultValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

