/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class Status {
    public static final Status ACTIVE = new Status("active");
    public static final Status INACTIVE = new Status("inactive");
    public static final Status SUSPENDED = new Status("suspended");
    public static final Status ARCHIVED = new Status("archived");
    public static final Status EXPIRED = new Status("expired");
    public static final Status ERROR = new Status("error");
    private static final Map<String, Status> values = Status.createValuesMap();
    private static final Map<String, StatusEnum> enums = Status.createEnumsMap();
    private final String value;

    private Status(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status of(String value) {
        Class<Status> clazz = Status.class;
        synchronized (Status.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new Status((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<StatusEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Status other = (Status)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "Status [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status[] values() {
        Class<Status> clazz = Status.class;
        synchronized (Status.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new Status[0]);
        }
    }

    private static final Map<String, Status> createValuesMap() {
        LinkedHashMap<String, Status> map = new LinkedHashMap<String, Status>();
        map.put("active", ACTIVE);
        map.put("inactive", INACTIVE);
        map.put("suspended", SUSPENDED);
        map.put("archived", ARCHIVED);
        map.put("expired", EXPIRED);
        map.put("error", ERROR);
        return map;
    }

    private static final Map<String, StatusEnum> createEnumsMap() {
        HashMap<String, StatusEnum> map = new HashMap<String, StatusEnum>();
        map.put("active", StatusEnum.ACTIVE);
        map.put("inactive", StatusEnum.INACTIVE);
        map.put("suspended", StatusEnum.SUSPENDED);
        map.put("archived", StatusEnum.ARCHIVED);
        map.put("expired", StatusEnum.EXPIRED);
        map.put("error", StatusEnum.ERROR);
        return map;
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive"),
        SUSPENDED("suspended"),
        ARCHIVED("archived"),
        EXPIRED("expired"),
        ERROR("error");

        private final String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<Status> {
        protected _Deserializer() {
            super(Status.class);
        }

        public Status deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return Status.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<Status> {
        protected _Serializer() {
            super(Status.class);
        }

        public void serialize(Status value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

