/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;


public class DocumentsDownloadFileRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * The session token
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-stackone-api-session-token")
    private Optional<String> xStackoneApiSessionToken;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    /**
     * The format to download the file in
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=format")
    private JsonNullable<String> format;

    /**
     * The export format of the file
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=export_format")
    private JsonNullable<String> exportFormat;

    @JsonCreator
    public DocumentsDownloadFileRequest(
            String xAccountId,
            Optional<String> xStackoneApiSessionToken,
            String id,
            JsonNullable<String> format,
            JsonNullable<String> exportFormat) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(format, "format");
        Utils.checkNotNull(exportFormat, "exportFormat");
        this.xAccountId = xAccountId;
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        this.id = id;
        this.format = format;
        this.exportFormat = exportFormat;
    }
    
    public DocumentsDownloadFileRequest(
            String xAccountId,
            String id) {
        this(xAccountId, Optional.empty(), id,
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * The session token
     */
    @JsonIgnore
    public Optional<String> xStackoneApiSessionToken() {
        return xStackoneApiSessionToken;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    /**
     * The format to download the file in
     */
    @JsonIgnore
    public JsonNullable<String> format() {
        return format;
    }

    /**
     * The export format of the file
     */
    @JsonIgnore
    public JsonNullable<String> exportFormat() {
        return exportFormat;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public DocumentsDownloadFileRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * The session token
     */
    public DocumentsDownloadFileRequest withXStackoneApiSessionToken(String xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
        return this;
    }


    /**
     * The session token
     */
    public DocumentsDownloadFileRequest withXStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        return this;
    }

    public DocumentsDownloadFileRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * The format to download the file in
     */
    public DocumentsDownloadFileRequest withFormat(String format) {
        Utils.checkNotNull(format, "format");
        this.format = JsonNullable.of(format);
        return this;
    }

    /**
     * The format to download the file in
     */
    public DocumentsDownloadFileRequest withFormat(JsonNullable<String> format) {
        Utils.checkNotNull(format, "format");
        this.format = format;
        return this;
    }

    /**
     * The export format of the file
     */
    public DocumentsDownloadFileRequest withExportFormat(String exportFormat) {
        Utils.checkNotNull(exportFormat, "exportFormat");
        this.exportFormat = JsonNullable.of(exportFormat);
        return this;
    }

    /**
     * The export format of the file
     */
    public DocumentsDownloadFileRequest withExportFormat(JsonNullable<String> exportFormat) {
        Utils.checkNotNull(exportFormat, "exportFormat");
        this.exportFormat = exportFormat;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DocumentsDownloadFileRequest other = (DocumentsDownloadFileRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.xStackoneApiSessionToken, other.xStackoneApiSessionToken) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.format, other.format) &&
            Utils.enhancedDeepEquals(this.exportFormat, other.exportFormat);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, xStackoneApiSessionToken, id,
            format, exportFormat);
    }
    
    @Override
    public String toString() {
        return Utils.toString(DocumentsDownloadFileRequest.class,
                "xAccountId", xAccountId,
                "xStackoneApiSessionToken", xStackoneApiSessionToken,
                "id", id,
                "format", format,
                "exportFormat", exportFormat);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> xStackoneApiSessionToken = Optional.empty();

        private String id;

        private JsonNullable<String> format = JsonNullable.undefined();

        private JsonNullable<String> exportFormat = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * The session token
         */
        public Builder xStackoneApiSessionToken(String xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
            return this;
        }

        /**
         * The session token
         */
        public Builder xStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = xStackoneApiSessionToken;
            return this;
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * The format to download the file in
         */
        public Builder format(String format) {
            Utils.checkNotNull(format, "format");
            this.format = JsonNullable.of(format);
            return this;
        }

        /**
         * The format to download the file in
         */
        public Builder format(JsonNullable<String> format) {
            Utils.checkNotNull(format, "format");
            this.format = format;
            return this;
        }


        /**
         * The export format of the file
         */
        public Builder exportFormat(String exportFormat) {
            Utils.checkNotNull(exportFormat, "exportFormat");
            this.exportFormat = JsonNullable.of(exportFormat);
            return this;
        }

        /**
         * The export format of the file
         */
        public Builder exportFormat(JsonNullable<String> exportFormat) {
            Utils.checkNotNull(exportFormat, "exportFormat");
            this.exportFormat = exportFormat;
            return this;
        }

        public DocumentsDownloadFileRequest build() {

            return new DocumentsDownloadFileRequest(
                xAccountId, xStackoneApiSessionToken, id,
                format, exportFormat);
        }

    }
}
