/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingAttachmentResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TicketingGetAttachmentResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TicketingAttachmentResult> ticketingAttachmentResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public TicketingGetAttachmentResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TicketingAttachmentResult> ticketingAttachmentResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(ticketingAttachmentResult, "ticketingAttachmentResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.ticketingAttachmentResult = ticketingAttachmentResult;
        this.headers = headers;
    }

    public TicketingGetAttachmentResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TicketingAttachmentResult> ticketingAttachmentResult() {
        return this.ticketingAttachmentResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingGetAttachmentResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public TicketingGetAttachmentResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public TicketingGetAttachmentResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public TicketingGetAttachmentResponse withTicketingAttachmentResult(TicketingAttachmentResult ticketingAttachmentResult) {
        Utils.checkNotNull(ticketingAttachmentResult, "ticketingAttachmentResult");
        this.ticketingAttachmentResult = Optional.ofNullable(ticketingAttachmentResult);
        return this;
    }

    public TicketingGetAttachmentResponse withTicketingAttachmentResult(Optional<? extends TicketingAttachmentResult> ticketingAttachmentResult) {
        Utils.checkNotNull(ticketingAttachmentResult, "ticketingAttachmentResult");
        this.ticketingAttachmentResult = ticketingAttachmentResult;
        return this;
    }

    public TicketingGetAttachmentResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingGetAttachmentResponse other = (TicketingGetAttachmentResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.ticketingAttachmentResult, other.ticketingAttachmentResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.ticketingAttachmentResult, this.headers);
    }

    public String toString() {
        return Utils.toString(TicketingGetAttachmentResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "ticketingAttachmentResult", this.ticketingAttachmentResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TicketingAttachmentResult> ticketingAttachmentResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder ticketingAttachmentResult(TicketingAttachmentResult ticketingAttachmentResult) {
            Utils.checkNotNull(ticketingAttachmentResult, "ticketingAttachmentResult");
            this.ticketingAttachmentResult = Optional.ofNullable(ticketingAttachmentResult);
            return this;
        }

        public Builder ticketingAttachmentResult(Optional<? extends TicketingAttachmentResult> ticketingAttachmentResult) {
            Utils.checkNotNull(ticketingAttachmentResult, "ticketingAttachmentResult");
            this.ticketingAttachmentResult = ticketingAttachmentResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public TicketingGetAttachmentResponse build() {
            return new TicketingGetAttachmentResponse(this.contentType, this.statusCode, this.rawResponse, this.ticketingAttachmentResult, this.headers);
        }
    }
}

