/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.WriteResultApiModel;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisUploadEmployeeDocumentResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends WriteResultApiModel> writeResultApiModel;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisUploadEmployeeDocumentResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends WriteResultApiModel> writeResultApiModel, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(writeResultApiModel, "writeResultApiModel");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.writeResultApiModel = writeResultApiModel;
        this.headers = headers;
    }

    public HrisUploadEmployeeDocumentResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<WriteResultApiModel> writeResultApiModel() {
        return this.writeResultApiModel;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisUploadEmployeeDocumentResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisUploadEmployeeDocumentResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisUploadEmployeeDocumentResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisUploadEmployeeDocumentResponse withWriteResultApiModel(WriteResultApiModel writeResultApiModel) {
        Utils.checkNotNull(writeResultApiModel, "writeResultApiModel");
        this.writeResultApiModel = Optional.ofNullable(writeResultApiModel);
        return this;
    }

    public HrisUploadEmployeeDocumentResponse withWriteResultApiModel(Optional<? extends WriteResultApiModel> writeResultApiModel) {
        Utils.checkNotNull(writeResultApiModel, "writeResultApiModel");
        this.writeResultApiModel = writeResultApiModel;
        return this;
    }

    public HrisUploadEmployeeDocumentResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisUploadEmployeeDocumentResponse other = (HrisUploadEmployeeDocumentResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.writeResultApiModel, other.writeResultApiModel) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.writeResultApiModel, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisUploadEmployeeDocumentResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "writeResultApiModel", this.writeResultApiModel, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends WriteResultApiModel> writeResultApiModel = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder writeResultApiModel(WriteResultApiModel writeResultApiModel) {
            Utils.checkNotNull(writeResultApiModel, "writeResultApiModel");
            this.writeResultApiModel = Optional.ofNullable(writeResultApiModel);
            return this;
        }

        public Builder writeResultApiModel(Optional<? extends WriteResultApiModel> writeResultApiModel) {
            Utils.checkNotNull(writeResultApiModel, "writeResultApiModel");
            this.writeResultApiModel = writeResultApiModel;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisUploadEmployeeDocumentResponse build() {
            return new HrisUploadEmployeeDocumentResponse(this.contentType, this.statusCode, this.rawResponse, this.writeResultApiModel, this.headers);
        }
    }
}

